/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.container;

import net.minecraft.client.gui.container.AbstractContainerScreen;
import net.minecraft.core.player.inventory.container.Container;
import net.minecraft.core.player.inventory.menu.ContainerMenu;
import org.lwjgl.opengl.GL11;

public class ContainerScreen
extends AbstractContainerScreen {
    private Container upperChestInventory;
    private Container lowerChestInventory;
    private int inventoryRows = 0;

    public ContainerScreen(Container containerUpper, Container containerLower) {
        super(new ContainerMenu(containerUpper, containerLower));
        this.upperChestInventory = containerUpper;
        this.lowerChestInventory = containerLower;
        this.passEvents = false;
        int i = 113;
        this.inventoryRows = containerLower.getContainerSize() / 9;
        this.ySize = i + this.inventoryRows * 18;
    }

    @Override
    protected void drawGuiContainerForegroundLayer() {
        this.font.drawString(this.lowerChestInventory.getName(), 8, 6, 0x404040);
        this.font.drawString(this.upperChestInventory.getName(), 8, this.ySize - 96 + 2, 0x404040);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float f) {
        GL11.glEnable(3042);
        GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        this.mc.textureManager.loadTexture("/assets/minecraft/textures/gui/container/container.png").bind();
        int x = (this.width - this.xSize) / 2;
        int y = (this.height - this.ySize) / 2;
        int h1 = Math.min(this.inventoryRows, 6) * 18 + 17;
        this.drawTexturedModalRect(x, y, 0, 0, this.xSize, h1);
        int rows = this.inventoryRows;
        while (rows > 6) {
            int h2 = Math.min(rows, 6) * 18;
            this.drawTexturedModalRect(x, y + h1, 0, 17, this.xSize, h2);
            rows -= 6;
            h1 += h2;
        }
        this.drawTexturedModalRect(x, y + this.inventoryRows * 18 + 17, 0, 126, this.xSize, 96);
    }
}

