/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.guidebook.crafting.displays;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.gui.guidebook.GuidebookSlot;
import net.minecraft.client.gui.guidebook.crafting.displays.RecipeDisplayAdapter;
import net.minecraft.core.data.registry.recipe.RecipeEntryBase;
import net.minecraft.core.data.registry.recipe.RecipeSymbol;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryRepairable;
import net.minecraft.core.item.ItemStack;

public class RepairableDisplayAdapter
implements RecipeDisplayAdapter<RecipeEntryRepairable> {
    @Override
    public List<GuidebookSlot> getSlots(RecipeEntryRepairable recipe, int recipeAmount, int xOffset, int yOffset) {
        ArrayList<GuidebookSlot> recipeSlots = new ArrayList<GuidebookSlot>();
        ItemStack[] sharedItemBuffer = new ItemStack[1];
        int[] sharedInt = new int[1];
        RecipeSymbol[] symbols = new RecipeSymbol[]{new RecipeSymbol(recipe.inItem), recipe.repairMaterial, recipe.repairMaterial, recipe.repairMaterial, new RecipeSymbol(recipe.inItem)};
        for (int i = 0; i < 4; ++i) {
            int x = 13 + 18 * (i % 2) + xOffset;
            int y = 10 + 18 * (i / 2 + recipeAmount * 3) + yOffset;
            GuidebookSlot slot = i == 0 ? new RepariableGuidebookSlot(i, x, y, symbols[i], false, recipe, sharedItemBuffer) : new MaterialGuidebookSlot(i, x, y, symbols[i], false, recipe, sharedInt);
            recipeSlots.add(slot);
        }
        int centerY = (((GuidebookSlot)recipeSlots.get((int)(recipeSlots.size() - 1))).y + ((GuidebookSlot)recipeSlots.get((int)(recipeSlots.size() - 3))).y) / 2;
        recipeSlots.add(new RepairOutputGuidebookSlot(symbols.length - 1, 81 + xOffset, centerY, symbols[4], false, recipe, sharedItemBuffer, sharedInt).setAsOutput());
        return recipeSlots;
    }

    public static class RepariableGuidebookSlot
    extends GuidebookSlot {
        private final ItemStack[] buffer;
        private int tickCount = 0;

        public RepariableGuidebookSlot(int id, int x, int y, RecipeSymbol symbol, boolean discovered, RecipeEntryBase<?, ?, ?> recipe, ItemStack[] itemBuffer) {
            super(id, x, y, symbol, discovered, recipe);
            this.buffer = itemBuffer;
        }

        @Override
        public void showRandomItem() {
            ++this.tickCount;
            if (this.tickCount % 3 == 1) {
                Random r = new Random();
                if (this.symbol != null && this.symbol.getItemGroup() != null) {
                    List<ItemStack> list = this.symbol.resolve();
                    ItemStack newItem = list.get(r.nextInt(list.size()));
                    if (list.size() > 1) {
                        while (newItem == this.item) {
                            newItem = list.get(r.nextInt(list.size()));
                        }
                    }
                    this.item = newItem;
                }
                this.item.setMetadata(r.nextInt(this.item.getMaxDamage()));
            }
            this.buffer[0] = this.item;
        }
    }

    public static class MaterialGuidebookSlot
    extends GuidebookSlot {
        private final int[] buffer;

        public MaterialGuidebookSlot(int id, int x, int y, RecipeSymbol symbol, boolean discovered, RecipeEntryBase<?, ?, ?> recipe, int[] intBuffer) {
            super(id, x, y, symbol, discovered, recipe);
            this.buffer = intBuffer;
        }

        @Override
        public void showRandomItem() {
            Random r = new Random(System.currentTimeMillis());
            if (this.index == 1) {
                this.buffer[0] = 0;
            }
            if (r.nextInt(3) >= this.index) {
                this.item = null;
                return;
            }
            this.buffer[0] = this.buffer[0] + 1;
            if (this.symbol != null && this.symbol.getItemGroup() != null) {
                List<ItemStack> list = this.symbol.resolve();
                ItemStack newItem = list.get(r.nextInt(list.size()));
                if (list.size() > 1) {
                    while (newItem == this.item) {
                        newItem = list.get(r.nextInt(list.size()));
                    }
                }
                this.item = newItem;
            } else if (this.symbol != null) {
                this.item = this.symbol.resolve().get(0);
            }
        }
    }

    public static class RepairOutputGuidebookSlot
    extends GuidebookSlot {
        private final ItemStack[] itemBuffer;
        private final int[] intBuffer;

        public RepairOutputGuidebookSlot(int id, int x, int y, RecipeSymbol symbol, boolean discovered, RecipeEntryBase<?, ?, ?> recipe, ItemStack[] itemBuffer, int[] intBuffer) {
            super(id, x, y, symbol, discovered, recipe);
            this.itemBuffer = itemBuffer;
            this.intBuffer = intBuffer;
        }

        @Override
        public void showRandomItem() {
            if (this.itemBuffer[0] == null) {
                this.item = null;
                return;
            }
            int chains = this.intBuffer[0];
            this.item = new ItemStack(this.itemBuffer[0]);
            for (int i = 0; i < chains; ++i) {
                if (this.item.getMetadata() > this.item.getMaxDamage()) continue;
                this.item.setMetadata(this.item.getMetadata() - this.item.getMaxDamage() / 8);
            }
            if (this.item.getMetadata() < 0) {
                this.item.setMetadata(0);
            }
        }
    }
}

