/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.hud.component;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.hud.IngameHud;
import net.minecraft.client.gui.hud.component.MovableHudComponent;
import net.minecraft.client.gui.hud.component.layout.Layout;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.item.FoodItem;
import net.minecraft.core.item.IceCreamBucketItem;
import net.minecraft.core.player.gamemode.Gamemode;
import org.lwjgl.opengl.GL11;

public class HealthBarComponent
extends MovableHudComponent {
    private final Random random = new Random();

    public HealthBarComponent(String key, Layout layout) {
        super(key, 81, 10, layout);
    }

    @Override
    public boolean isVisible(Minecraft mc) {
        return mc.playerController.canHurtPlayer() && !mc.thePlayer.getGamemode().isPlayerInvulnerable() && mc.gameSettings.immersiveMode.drawHotbar();
    }

    @Override
    public void render(Minecraft mc, IngameHud hud, int xSizeScreen, int ySizeScreen, float partialTick) {
        boolean heartsFlash;
        int x = this.getLayout().getComponentX(mc, this, xSizeScreen);
        int y = this.getLayout().getComponentY(mc, this, ySizeScreen);
        GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        GL11.glDisable(3042);
        boolean bl = heartsFlash = mc.thePlayer.heartsFlashTime / 3 % 2 == 1;
        if (mc.thePlayer.heartsFlashTime < 10) {
            heartsFlash = false;
        }
        int health = mc.thePlayer.getHealth();
        int prevHealth = mc.thePlayer.prevHealth;
        this.random.setSeed((long)hud.updateCounter * 312871L);
        boolean isHardcore = mc.thePlayer.getGamemode() == Gamemode.hardcore;
        for (int i = 0; i < 10; ++i) {
            boolean heartOffset = false;
            if (heartsFlash) {
                heartOffset = true;
            }
            int xHeart = x + i * 8;
            int yHeart = y;
            if (health <= 4) {
                yHeart += this.random.nextInt(2);
            }
            hud.drawGuiIcon(xHeart, yHeart, 9, 9, !heartOffset ? TextureRegistry.getTexture("minecraft:gui/hud/heart/container") : TextureRegistry.getTexture("minecraft:gui/hud/heart/container_blinking"));
            if (heartsFlash) {
                if (i * 2 + 1 < prevHealth) {
                    hud.drawGuiIcon(xHeart, yHeart, 9, 9, TextureRegistry.getTexture("minecraft:gui/hud/heart/" + (isHardcore ? "hardcore_" : "") + "full_blinking"));
                }
                if (i * 2 + 1 == prevHealth) {
                    hud.drawGuiIcon(xHeart, yHeart, 9, 9, TextureRegistry.getTexture("minecraft:gui/hud/heart/" + (isHardcore ? "hardcore_" : "") + "half_blinking"));
                }
            }
            if (i * 2 + 1 < health) {
                hud.drawGuiIcon(xHeart, yHeart, 9, 9, TextureRegistry.getTexture("minecraft:gui/hud/heart/" + (isHardcore ? "hardcore_" : "") + "full"));
            }
            if (i * 2 + 1 == health) {
                hud.drawGuiIcon(xHeart, yHeart, 9, 9, TextureRegistry.getTexture("minecraft:gui/hud/heart/" + (isHardcore ? "hardcore_" : "") + "half"));
            }
            if (mc.thePlayer.inventory.getCurrentItem() == null || !(mc.thePlayer.inventory.getCurrentItem().getItem() instanceof FoodItem) && !(mc.thePlayer.inventory.getCurrentItem().getItem() instanceof IceCreamBucketItem) || !((Boolean)mc.gameSettings.foodHealthRegenOverlay.value).booleanValue()) continue;
            int healing = 0;
            healing = mc.thePlayer.inventory.getCurrentItem().getItem() instanceof FoodItem ? ((FoodItem)mc.thePlayer.inventory.getCurrentItem().getItem()).getHealAmount() : ((IceCreamBucketItem)mc.thePlayer.inventory.getCurrentItem().getItem()).getHealAmount();
            if (i * 2 + 1 < health) continue;
            if (i * 2 + 1 == health) {
                hud.drawGuiIcon(xHeart, yHeart, 9, 9, TextureRegistry.getTexture("minecraft:gui/hud/heart/" + (isHardcore ? "hardcore_" : "") + "preview_half_right"));
                continue;
            }
            if (i * 2 + 1 < health + healing) {
                hud.drawGuiIcon(xHeart, yHeart, 9, 9, TextureRegistry.getTexture("minecraft:gui/hud/heart/" + (isHardcore ? "hardcore_" : "") + "preview_full"));
                continue;
            }
            if (i * 2 + 1 != health + healing) continue;
            hud.drawGuiIcon(xHeart, yHeart, 9, 9, TextureRegistry.getTexture("minecraft:gui/hud/heart/" + (isHardcore ? "hardcore_" : "") + "preview_half"));
        }
    }

    @Override
    public void renderPreview(Minecraft mc, Gui gui, Layout layout, int xSizeScreen, int ySizeScreen) {
        int x = layout.getComponentX(mc, this, xSizeScreen);
        int y = layout.getComponentY(mc, this, ySizeScreen);
        GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        GL11.glDisable(3042);
        int health = 11;
        for (int i = 0; i < 10; ++i) {
            int xHeart = x + i * 8;
            gui.drawGuiIcon(xHeart, y, 9, 9, TextureRegistry.getTexture("minecraft:gui/hud/heart/container"));
            if (i * 2 + 1 < health) {
                gui.drawGuiIcon(xHeart, y, 9, 9, TextureRegistry.getTexture("minecraft:gui/hud/heart/full"));
            }
            if (i * 2 + 1 != health) continue;
            gui.drawGuiIcon(xHeart, y, 9, 9, TextureRegistry.getTexture("minecraft:gui/hud/heart/half"));
        }
    }
}

