/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.modelviewer.categories.entries.block;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.modelviewer.ModelViewerScreen;
import net.minecraft.client.gui.modelviewer.categories.entries.block.BlockEntry;
import net.minecraft.client.gui.modelviewer.elements.TextCycleElement;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.FlowerJarBlockEntity;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.DisplayChunk;

public class JarEntry
extends BlockEntry {
    public JarEntry() {
        super(Blocks.JAR_GLASS);
    }

    @Override
    public void onTick(World world, int meta) {
    }

    @Override
    public List<ButtonElement> getEntryButtons(Minecraft mc, Screen parentScreen, World world, int meta) {
        final TextCycleElement<Integer> jarCycle = new TextCycleElement<Integer>(parentScreen, mc.font, -120, 0, 120, 20, Integer.valueOf(0)){

            @Override
            public Integer cycleElement(Integer current, int offset) {
                return ModelViewerScreen.cycleBlockId(current, offset);
            }

            @Override
            public Integer getElementFromString(String s) {
                try {
                    int id = MathHelper.clamp(Integer.parseInt(s), 0, Block.blocksList.length);
                    if (Block.getBlock(id) != null) {
                        return id;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return DisplayChunk.displayBlockId;
            }

            @Override
            public String getNameFromElement(Integer element) {
                return String.valueOf(element);
            }
        };
        jarCycle.textField.setPrefaceText("Jar: ");
        jarCycle.textField.setPlaceholder("Jar ID");
        jarCycle.setOnValueChanged(() -> {
            ((FlowerJarBlockEntity)DisplayChunk.displayBlockEntity).flowerInPot = (Integer)jarCycle.getCurrentElement();
        });
        return new ArrayList<ButtonElement>(){
            {
                this.add(jarCycle);
            }
        };
    }

    @Override
    public void onClose(World world, int meta) {
    }

    @Override
    public void onOpen(World world, int meta) {
    }
}

