/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.modelviewer.categories.entries.entity;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.modelviewer.categories.entries.entity.EntityEntry;
import net.minecraft.client.gui.modelviewer.elements.ListenerButtonElement;
import net.minecraft.core.block.entity.FlagBlockEntity;
import net.minecraft.core.entity.vehicle.BoatEntity;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.world.World;

public class EntityBoatEntry
extends EntityEntry<BoatEntity> {
    @Override
    public void onTick(BoatEntity entity) {
    }

    @Override
    public List<ButtonElement> getEntryButtons(Minecraft mc, Screen parentScreen, BoatEntity entity) {
        final ListenerButtonElement flagButton = new ListenerButtonElement(-1, -120, 0, 120, 20, I18n.getInstance().translateKeyAndFormat("model.category.entity.boat.button.flag", false));
        flagButton.setActionListener(() -> {
            boolean flag;
            if (entity.tileEntityFlag == null) {
                entity.tileEntityFlag = new FlagBlockEntity();
                flag = true;
            } else {
                entity.tileEntityFlag = null;
                flag = false;
            }
            flagButton.displayString = I18n.getInstance().translateKeyAndFormat("model.category.entity.boat.button.flag", flag);
        });
        return new ArrayList<ButtonElement>(){
            {
                this.add(flagButton);
            }
        };
    }

    @Override
    public BoatEntity getEntityInstance(Minecraft mc, World world) {
        BoatEntity boat = new BoatEntity(world);
        boat.yRot = 270.0f;
        boat.zd = 100.0;
        return boat;
    }

    @Override
    public void onOpen() {
    }

    @Override
    public void onClose() {
    }
}

