/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.options.components;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IntegerSliderElement;
import net.minecraft.client.gui.options.components.ButtonComponent;
import net.minecraft.client.option.EnumOption;
import net.minecraft.core.enums.Difficulty;
import net.minecraft.core.lang.I18n;

public class DifficultyOptionComponent
extends ButtonComponent {
    protected final EnumOption<Difficulty> option;
    protected final IntegerSliderElement slider;

    public DifficultyOptionComponent(EnumOption<Difficulty> difficultyOption) {
        super("options." + difficultyOption.name);
        this.option = difficultyOption;
        this.slider = new IntegerSliderElement(0, 0, 0, 150, 20, this.option);
    }

    @Override
    protected void buttonClicked(int mouseButton, int x, int y, int width, int height, int relativeMouseX, int relativeMouseY) {
        this.slider.mouseClicked(mc, this.slider.xPosition + relativeMouseX, this.slider.yPosition + relativeMouseY);
        this.slider.displayString = this.getDisplayString();
        this.option.onUpdate();
    }

    @Override
    protected void buttonDragged(int x, int y, int width, int height, int relativeMouseX, int relativeMouseY) {
        this.slider.displayString = this.getDisplayString();
        this.option.onUpdate();
    }

    @Override
    protected void buttonReleased(int mouseButton, int x, int y, int width, int height, int relativeMouseX, int relativeMouseY) {
        this.slider.mouseReleased(this.slider.xPosition + relativeMouseX, this.slider.yPosition + relativeMouseY);
        this.slider.displayString = this.getDisplayString();
        this.option.onUpdate();
    }

    @Override
    protected void renderButton(int x, int y, int relativeButtonX, int relativeButtonY, int buttonWidth, int buttonHeight, int relativeMouseX, int relativeMouseY) {
        this.slider.enabled = this.canSetDifficulty();
        super.renderButton(x, y, relativeButtonX, relativeButtonY, buttonWidth, buttonHeight, relativeMouseX, relativeMouseY);
        this.slider.xPosition = x + relativeButtonX;
        this.slider.yPosition = y + relativeButtonY;
        this.slider.width = buttonWidth;
        this.slider.height = buttonHeight;
        this.slider.drawButton(mc, x + relativeMouseX, y + relativeMouseY);
    }

    @Override
    public void init(Minecraft mc) {
        if (!this.canSetDifficulty()) {
            this.slider.enabled = false;
            this.slider.sliderValue = Difficulty.NORMAL.id();
            this.slider.displayString = this.getDisplayString();
            return;
        }
        this.slider.enabled = true;
        this.option.set(mc.theWorld.getDifficulty());
        this.slider.sliderValue = ((Difficulty)((Object)this.option.value)).id();
        this.slider.displayString = this.getDisplayString();
    }

    @Override
    public void resetValue() {
        if (this.canSetDifficulty()) {
            DifficultyOptionComponent.mc.theWorld.setDifficulty(Difficulty.NORMAL, false);
        }
    }

    @Override
    public boolean isDefault() {
        boolean canSet = this.canSetDifficulty();
        return !canSet || DifficultyOptionComponent.mc.theWorld.getDifficulty() == Difficulty.NORMAL;
    }

    protected String getDisplayString() {
        if (!this.canSetDifficulty()) {
            return I18n.getInstance().translateKey("options.difficulty.locked");
        }
        return this.option.getDisplayStringValue();
    }

    protected boolean canSetDifficulty() {
        return DifficultyOptionComponent.mc.theWorld != null && !DifficultyOptionComponent.mc.theWorld.getLevelData().getDifficultyLocked() && !DifficultyOptionComponent.mc.theWorld.isClientSide;
    }
}

