/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.net.handler;

import com.b100.utils.StringUtils;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.particle.TakeAnimationParticle;
import net.minecraft.client.entity.player.LocalPlayer;
import net.minecraft.client.entity.player.RemotePlayer;
import net.minecraft.client.gui.ConnectFailedScreen;
import net.minecraft.client.gui.DownloadTerrainScreen;
import net.minecraft.client.gui.PauseScreen;
import net.minecraft.client.gui.chat.ChatSuggestionsElement;
import net.minecraft.client.gui.guidebook.GuidebookScreen;
import net.minecraft.client.gui.guidebook.PageManager;
import net.minecraft.client.gui.guidebook.search.SearchPage;
import net.minecraft.client.player.controller.PlayerControllerMP;
import net.minecraft.client.world.WorldClient;
import net.minecraft.core.achievement.stat.StatList;
import net.minecraft.core.block.entity.ActivatorBlockEntity;
import net.minecraft.core.block.entity.BlastFurnaceBlockEntity;
import net.minecraft.core.block.entity.BlockEntity;
import net.minecraft.core.block.entity.BlockEntityDispatcher;
import net.minecraft.core.block.entity.DispenserBlockEntity;
import net.minecraft.core.block.entity.FlagBlockEntity;
import net.minecraft.core.block.entity.FurnaceBlockEntity;
import net.minecraft.core.block.entity.MobSpawnerBlockEntity;
import net.minecraft.core.block.entity.TrommelBlockEntity;
import net.minecraft.core.data.DataLoader;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.data.registry.recipe.RecipeRegistry;
import net.minecraft.core.data.registry.recipe.SearchQuery;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityDispatcher;
import net.minecraft.core.entity.ItemEntity;
import net.minecraft.core.entity.LightningEntity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.PaintingEntity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.entity.projectile.Projectile;
import net.minecraft.core.enums.ArtType;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.item.MapItem;
import net.minecraft.core.net.NetworkManager;
import net.minecraft.core.net.PlayerProfile;
import net.minecraft.core.net.entity.NetEntityHandler;
import net.minecraft.core.net.handler.PacketHandler;
import net.minecraft.core.net.packet.AESSendKeyPacket;
import net.minecraft.core.net.packet.AddEntityPacket;
import net.minecraft.core.net.packet.AddItemEntityPacket;
import net.minecraft.core.net.packet.AddMobPacket;
import net.minecraft.core.net.packet.AddPaintingPacket;
import net.minecraft.core.net.packet.AddParticlePacket;
import net.minecraft.core.net.packet.AddPlayerPacket;
import net.minecraft.core.net.packet.AnimatePacket;
import net.minecraft.core.net.packet.BedMessagePacket;
import net.minecraft.core.net.packet.BlockEntityDataPacket;
import net.minecraft.core.net.packet.BlockEventPacket;
import net.minecraft.core.net.packet.BlockRegionUpdatePacket;
import net.minecraft.core.net.packet.BlockUpdatePacket;
import net.minecraft.core.net.packet.ChatPacket;
import net.minecraft.core.net.packet.ChunkBlocksUpdatePacket;
import net.minecraft.core.net.packet.ChunkVisibilityPacket;
import net.minecraft.core.net.packet.CommandManagerPacket;
import net.minecraft.core.net.packet.ContainerAckPacket;
import net.minecraft.core.net.packet.ContainerClosePacket;
import net.minecraft.core.net.packet.ContainerOpenPacket;
import net.minecraft.core.net.packet.ContainerSetContentPacket;
import net.minecraft.core.net.packet.ContainerSetDataPacket;
import net.minecraft.core.net.packet.ContainerSetSlotPacket;
import net.minecraft.core.net.packet.CustomPayloadPacket;
import net.minecraft.core.net.packet.DisconnectPacket;
import net.minecraft.core.net.packet.EnitityEventPacket;
import net.minecraft.core.net.packet.EntityNicknamePacket;
import net.minecraft.core.net.packet.EntityTagDataPacket;
import net.minecraft.core.net.packet.ExplosionPacket;
import net.minecraft.core.net.packet.FlagOpenPacket;
import net.minecraft.core.net.packet.GameRulePacket;
import net.minecraft.core.net.packet.LoginPacket;
import net.minecraft.core.net.packet.MapDataPacket;
import net.minecraft.core.net.packet.MoveEntityPacket;
import net.minecraft.core.net.packet.MovePlayerPacket;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.core.net.packet.PhotoModePacket;
import net.minecraft.core.net.packet.PlaySoundEffectDirectPacket;
import net.minecraft.core.net.packet.PlaySoundEffectPacket;
import net.minecraft.core.net.packet.PlayerGamemodePacket;
import net.minecraft.core.net.packet.PlayerListPacket;
import net.minecraft.core.net.packet.PreLoginPacket;
import net.minecraft.core.net.packet.RecipeSyncPacket;
import net.minecraft.core.net.packet.RemoveEntityPacket;
import net.minecraft.core.net.packet.RespawnPacket;
import net.minecraft.core.net.packet.SetCarriedItemPacket;
import net.minecraft.core.net.packet.SetEntityDataPacket;
import net.minecraft.core.net.packet.SetEntityMotionPacket;
import net.minecraft.core.net.packet.SetEquippedItemPacket;
import net.minecraft.core.net.packet.SetHealthPacket;
import net.minecraft.core.net.packet.SetHeldObjectPacket;
import net.minecraft.core.net.packet.SetHotbarOffsetPacket;
import net.minecraft.core.net.packet.SetMobSpawnerPacket;
import net.minecraft.core.net.packet.SetRidingPacket;
import net.minecraft.core.net.packet.SetSpawnPositionPacket;
import net.minecraft.core.net.packet.SetTimePacket;
import net.minecraft.core.net.packet.SleepPacket;
import net.minecraft.core.net.packet.StatisticPacket;
import net.minecraft.core.net.packet.SyncIDsPacket;
import net.minecraft.core.net.packet.TakeItemEntityPacket;
import net.minecraft.core.net.packet.TeleportEntityPacket;
import net.minecraft.core.net.packet.UpdatePlayerProfilePacket;
import net.minecraft.core.net.packet.WeatherEffectPacket;
import net.minecraft.core.net.packet.WeatherStatusPacket;
import net.minecraft.core.player.gamemode.Gamemode;
import net.minecraft.core.player.inventory.container.SimpleContainer;
import net.minecraft.core.player.inventory.menu.AbstractContainerMenu;
import net.minecraft.core.sound.SoundTypes;
import net.minecraft.core.util.helper.AES;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.RSA;
import net.minecraft.core.world.Explosion;
import net.minecraft.core.world.ExplosionCannonball;
import net.minecraft.core.world.ICarriable;
import net.minecraft.core.world.IVehicle;
import net.minecraft.core.world.chunk.ChunkCoordinates;
import net.minecraft.core.world.data.SynchedEntityData;
import net.minecraft.core.world.save.LevelData;
import net.minecraft.core.world.saveddata.SavedDataStorage;
import net.minecraft.core.world.weather.Weather;
import net.minecraft.core.world.weather.Weathers;
import org.slf4j.Logger;

public class ClientPacketHandler
extends PacketHandler {
    private static final Logger LOGGER = LogUtils.getLogger();
    private boolean disconnected = false;
    private final NetworkManager netManager;
    public String message;
    private final Minecraft mc;
    private WorldClient worldClient;
    private boolean started = false;
    public SavedDataStorage savedDataStorage;
    public List<PlayerProfile> players;
    public HashMap<String, String> playerList = new HashMap();
    Random rand;

    public ClientPacketHandler(Minecraft minecraft, String host, int port) throws UnknownHostException, IOException {
        this.savedDataStorage = new SavedDataStorage(null);
        this.rand = new Random();
        this.mc = minecraft;
        Socket socket = new Socket(InetAddress.getByName(host), port);
        this.netManager = new NetworkManager(socket, "Client", this);
        this.players = new ArrayList<PlayerProfile>();
    }

    public void tick() {
        if (!this.disconnected) {
            this.netManager.processReadPackets();
        }
        this.netManager.wakeThreads();
    }

    public int findPlayerInList(PlayerProfile playerProfile) {
        for (int i = 0; i < this.players.size(); ++i) {
            if (!this.players.get((int)i).playerName.equals(playerProfile.playerName)) continue;
            return i;
        }
        return -1;
    }

    public void addPlayer(PlayerProfile playerProfile) {
        this.players.add(playerProfile);
    }

    public PlayerProfile getPlayer(String username) {
        for (PlayerProfile player : this.players) {
            if (!player.playerName.equals(username)) continue;
            return player;
        }
        return null;
    }

    public void removePlayer(int index) {
        this.players.remove(index);
    }

    @Override
    public void handleLogin(LoginPacket loginPacket) {
        this.mc.playerController = new PlayerControllerMP(this.mc, this);
        this.mc.statsCounter.add(StatList.joinMultiplayerStat, 1);
        this.worldClient = new WorldClient(this.mc, this, loginPacket.worldSeed, loginPacket.dimensionId, loginPacket.worldTypeId);
        this.worldClient.isClientSide = true;
        this.mc.changeWorld(this.worldClient);
        this.mc.thePlayer.dimension = loginPacket.dimensionId;
        this.mc.displayScreen(new DownloadTerrainScreen(this));
        this.mc.thePlayer.id = loginPacket.playerEntityIdAndProtocolVersion;
        NetworkManager.PACKET_DELAY = loginPacket.packetDelay;
        Registries.RECIPES = new RecipeRegistry();
    }

    @Override
    public void handlePickupSpawn(AddItemEntityPacket addItemEntityPacket) {
        double x = (double)addItemEntityPacket.xPosition / 32.0;
        double y = (double)addItemEntityPacket.yPosition / 32.0;
        double z = (double)addItemEntityPacket.zPosition / 32.0;
        ItemEntity itemEntity = new ItemEntity(this.worldClient, x, y, z, new ItemStack(addItemEntityPacket.itemID, addItemEntityPacket.count, addItemEntityPacket.itemDamage, addItemEntityPacket.tag));
        itemEntity.xd = (double)addItemEntityPacket.xd / 128.0;
        itemEntity.yd = (double)addItemEntityPacket.yd / 128.0;
        itemEntity.zd = (double)addItemEntityPacket.zd / 128.0;
        itemEntity.serverPosX = addItemEntityPacket.xPosition;
        itemEntity.serverPosY = addItemEntityPacket.yPosition;
        itemEntity.serverPosZ = addItemEntityPacket.zPosition;
        this.worldClient.addEntityToWorld(addItemEntityPacket.entityId, itemEntity);
    }

    @Override
    public void handleVehicleSpawn(AddEntityPacket addEntityPacket) {
        if (!NetEntityHandler.hasType(addEntityPacket.type)) {
            return;
        }
        double xPosition = (double)addEntityPacket.xPosition / 32.0;
        double yPosition = (double)addEntityPacket.yPosition / 32.0;
        double zPosition = (double)addEntityPacket.zPosition / 32.0;
        Entity owner = addEntityPacket.ownerId >= 0 ? this.getEntityByID(addEntityPacket.ownerId) : null;
        Entity newEntity = NetEntityHandler.getTypeEntry(addEntityPacket.type).getEntity(this.worldClient, xPosition, yPosition, zPosition, addEntityPacket.metaData, addEntityPacket.hasVelocity, (double)addEntityPacket.xVelocity / 8000.0, (double)addEntityPacket.yVelocity / 8000.0, (double)addEntityPacket.zVelocity / 8000.0, owner);
        if (newEntity != null) {
            newEntity.serverPosX = addEntityPacket.xPosition;
            newEntity.serverPosY = addEntityPacket.yPosition;
            newEntity.serverPosZ = addEntityPacket.zPosition;
            newEntity.yRot = addEntityPacket.yaw;
            newEntity.xRot = addEntityPacket.pitch;
            newEntity.id = addEntityPacket.entityId;
            this.worldClient.addEntityToWorld(addEntityPacket.entityId, newEntity);
            if (owner instanceof Mob && newEntity instanceof Projectile) {
                ((Projectile)newEntity).owner = (Mob)owner;
            }
            if (addEntityPacket.hasVelocity) {
                newEntity.lerpMotion((double)addEntityPacket.xVelocity / 8000.0, (double)addEntityPacket.yVelocity / 8000.0, (double)addEntityPacket.zVelocity / 8000.0);
            }
        }
    }

    @Override
    public void handleWeather(WeatherEffectPacket weatherEffectPacket) {
        double x = (double)weatherEffectPacket.x / 32.0;
        double y = (double)weatherEffectPacket.y / 32.0;
        double z = (double)weatherEffectPacket.z / 32.0;
        LightningEntity weatherEntity = null;
        if (weatherEffectPacket.effectId == 1) {
            weatherEntity = new LightningEntity(this.worldClient, x, y, z);
        }
        if (weatherEntity != null) {
            weatherEntity.serverPosX = weatherEffectPacket.x;
            weatherEntity.serverPosY = weatherEffectPacket.y;
            weatherEntity.serverPosZ = weatherEffectPacket.z;
            weatherEntity.yRot = 0.0f;
            weatherEntity.xRot = 0.0f;
            weatherEntity.id = weatherEffectPacket.id;
            this.worldClient.addWeatherEffect(weatherEntity);
        }
    }

    @Override
    public void handleWeatherStatus(WeatherStatusPacket packet) {
        if (this.worldClient.dimension.id != packet.dimId) {
            return;
        }
        Weather currentWeather = packet.id == -1 ? null : Weathers.WEATHERS[packet.id];
        Weather newWeather = packet.newId == -1 ? null : Weathers.WEATHERS[packet.newId];
        this.worldClient.weatherManager.overrideWeather(currentWeather, newWeather, packet.duration, packet.intensity, packet.power);
    }

    @Override
    public void handleEntityPainting(AddPaintingPacket addPaintingPacket) {
        Entity entity = this.worldClient.getEntityFromId(addPaintingPacket.entityId);
        if (entity instanceof PaintingEntity) {
            PaintingEntity painting = (PaintingEntity)entity;
            painting.blockX = addPaintingPacket.xPosition;
            painting.blockY = addPaintingPacket.yPosition;
            painting.blockZ = addPaintingPacket.zPosition;
            if (ArtType.map.containsKey(addPaintingPacket.key)) {
                painting.art = ArtType.map.get(addPaintingPacket.key);
            }
            painting.setDirection(addPaintingPacket.direction);
            if (addPaintingPacket.itemID > 0) {
                painting.setStack(new ItemStack(addPaintingPacket.itemID, 1, addPaintingPacket.meta));
            }
        } else {
            PaintingEntity entitypainting = new PaintingEntity(this.worldClient, addPaintingPacket.xPosition, addPaintingPacket.yPosition, addPaintingPacket.zPosition, addPaintingPacket.direction, addPaintingPacket.key);
            this.worldClient.addEntityToWorld(addPaintingPacket.entityId, entitypainting);
            if (addPaintingPacket.itemID > 0) {
                entitypainting.setStack(new ItemStack(addPaintingPacket.itemID, 1, addPaintingPacket.meta));
            }
        }
    }

    @Override
    public void handleEntityVelocity(SetEntityMotionPacket setEntityMotionPacket) {
        Entity entity = this.getEntityByID(setEntityMotionPacket.entityId);
        if (entity == null) {
            return;
        }
        entity.lerpMotion((double)setEntityMotionPacket.motionX / 8000.0, (double)setEntityMotionPacket.motionY / 8000.0, (double)setEntityMotionPacket.motionZ / 8000.0);
    }

    @Override
    public void handleEntityMetadata(SetEntityDataPacket setEntityDataPacket) {
        Entity entity = this.getEntityByID(setEntityDataPacket.entityId);
        if (entity != null && setEntityDataPacket.getUnpackedData() != null) {
            entity.getEntityData().assignValues(setEntityDataPacket.getUnpackedData());
        }
    }

    @Override
    public void handleNamedEntitySpawn(AddPlayerPacket addPlayerPacket) {
        double d = (double)addPlayerPacket.xPosition / 32.0;
        double d1 = (double)addPlayerPacket.yPosition / 32.0;
        double d2 = (double)addPlayerPacket.zPosition / 32.0;
        float f = (float)(addPlayerPacket.rotation * 360) / 256.0f;
        float f1 = (float)(addPlayerPacket.pitch * 360) / 256.0f;
        RemotePlayer remotePlayer = new RemotePlayer(this.mc.theWorld, addPlayerPacket.name, addPlayerPacket.uuid);
        remotePlayer.serverPosX = addPlayerPacket.xPosition;
        remotePlayer.xo = remotePlayer.serverPosX;
        remotePlayer.serverPosY = addPlayerPacket.yPosition;
        remotePlayer.yo = remotePlayer.serverPosY;
        remotePlayer.serverPosZ = addPlayerPacket.zPosition;
        remotePlayer.zo = remotePlayer.serverPosZ;
        int i = addPlayerPacket.currentItem;
        remotePlayer.inventory.mainInventory[remotePlayer.inventory.getCurrentItemIndex()] = i == 0 ? null : new ItemStack(i, 1, 0);
        remotePlayer.absMoveTo(d, d1, d2, f, f1);
        this.worldClient.addEntityToWorld(addPlayerPacket.entityId, remotePlayer);
        remotePlayer.nickname = StringUtils.substring(addPlayerPacket.nickname, 0, 32);
        remotePlayer.chatColor = addPlayerPacket.chatColor;
        remotePlayer.setHeldObject(addPlayerPacket.heldObjectTag == null ? null : ICarriable.createAndLoadCarriable(remotePlayer, addPlayerPacket.heldObjectTag));
    }

    @Override
    public void handleEntityTeleport(TeleportEntityPacket teleportEntityPacket) {
        Entity entity = this.getEntityByID(teleportEntityPacket.id);
        if (entity == null) {
            return;
        }
        entity.serverPosX = teleportEntityPacket.x;
        entity.serverPosY = teleportEntityPacket.y;
        entity.serverPosZ = teleportEntityPacket.z;
        double d = (double)entity.serverPosX / 32.0;
        double d1 = (double)entity.serverPosY / 32.0 + 0.015625;
        double d2 = (double)entity.serverPosZ / 32.0;
        float f = (float)(teleportEntityPacket.yaw * 360) / 256.0f;
        float f1 = (float)(teleportEntityPacket.pitch * 360) / 256.0f;
        entity.lerpTo(d, d1, d2, f, f1, 3);
    }

    @Override
    public void handleEntity(MoveEntityPacket moveEntityPacket) {
        Entity entity = this.getEntityByID(moveEntityPacket.id);
        if (entity == null) {
            return;
        }
        entity.serverPosX += moveEntityPacket.x;
        entity.serverPosY += moveEntityPacket.y;
        entity.serverPosZ += moveEntityPacket.z;
        double d = (double)entity.serverPosX / 32.0;
        double d1 = (double)entity.serverPosY / 32.0;
        double d2 = (double)entity.serverPosZ / 32.0;
        float f = moveEntityPacket.rotating ? (float)(moveEntityPacket.yaw * 360) / 256.0f : entity.yRot;
        float f1 = moveEntityPacket.rotating ? (float)(moveEntityPacket.pitch * 360) / 256.0f : entity.xRot;
        entity.lerpTo(d, d1, d2, f, f1, 3);
    }

    @Override
    public void handleEntityTagData(EntityTagDataPacket entityTagDataPacket) {
        Entity entity = this.getEntityByID(entityTagDataPacket.entityId);
        if (entity != null) {
            entity.readAdditionalSaveData(entityTagDataPacket.tag);
        }
    }

    @Override
    public void handleSetMobSpawner(SetMobSpawnerPacket setMobSpawnerPacket) {
        BlockEntity tileentity;
        if (this.mc.theWorld.isBlockLoaded(setMobSpawnerPacket.xPosition, setMobSpawnerPacket.yPosition, setMobSpawnerPacket.zPosition) && (tileentity = this.mc.theWorld.getBlockEntity(setMobSpawnerPacket.xPosition, setMobSpawnerPacket.yPosition, setMobSpawnerPacket.zPosition)) instanceof MobSpawnerBlockEntity) {
            MobSpawnerBlockEntity tileEntityMobSpawner = (MobSpawnerBlockEntity)tileentity;
            tileEntityMobSpawner.setMobId(setMobSpawnerPacket.spawnType);
            tileEntityMobSpawner.setChanged();
        }
    }

    @Override
    public void handleSetHotbarOffset(SetHotbarOffsetPacket setHotbarOffsetPacket) {
        this.mc.thePlayer.inventory.setHotbarOffset(setHotbarOffsetPacket.hotbarOffset, true);
    }

    @Override
    public void handleDestroyEntity(RemoveEntityPacket removeEntityPacket) {
        this.worldClient.removeEntityFromWorld(removeEntityPacket.entityId);
    }

    @Override
    public void handleFlying(MovePlayerPacket movePlayerPacket) {
        LocalPlayer entityplayersp = this.mc.thePlayer;
        double d = entityplayersp.x;
        double d1 = entityplayersp.y;
        double d2 = entityplayersp.z;
        float f = entityplayersp.yRot;
        float f1 = entityplayersp.xRot;
        if (movePlayerPacket.hasPosition) {
            d = movePlayerPacket.x;
            d1 = movePlayerPacket.y;
            d2 = movePlayerPacket.z;
        }
        if (movePlayerPacket.hasRotation) {
            f = movePlayerPacket.yaw;
            f1 = movePlayerPacket.pitch;
        }
        entityplayersp.ySlideOffset = 0.0f;
        entityplayersp.zd = 0.0;
        entityplayersp.yd = 0.0;
        entityplayersp.xd = 0.0;
        entityplayersp.absMoveTo(d, d1, d2, f, f1);
        movePlayerPacket.x = entityplayersp.x;
        movePlayerPacket.y = entityplayersp.bb.minY;
        movePlayerPacket.z = entityplayersp.z;
        this.netManager.addToSendQueue(movePlayerPacket);
        if (!this.started) {
            this.mc.thePlayer.xo = this.mc.thePlayer.x;
            this.mc.thePlayer.yo = this.mc.thePlayer.y;
            this.mc.thePlayer.zo = this.mc.thePlayer.z;
            this.started = true;
            this.mc.displayScreen(null);
        }
    }

    @Override
    public void handlePreChunk(ChunkVisibilityPacket chunkVisibilityPacket) {
        this.worldClient.doPreChunk(chunkVisibilityPacket.chunkX, chunkVisibilityPacket.chunkZ, chunkVisibilityPacket.playerAdded);
    }

    @Override
    public void handleMultiBlockChange(ChunkBlocksUpdatePacket chunkBlocksUpdatePacket) {
        int xBase = chunkBlocksUpdatePacket.xChunk * 16;
        int zBase = chunkBlocksUpdatePacket.zChunk * 16;
        for (int k = 0; k < chunkBlocksUpdatePacket.size; ++k) {
            int coord = chunkBlocksUpdatePacket.coordinateArray[k];
            int type = chunkBlocksUpdatePacket.typeArray[k] & 0x3FFF;
            byte data = chunkBlocksUpdatePacket.metadataArray[k];
            int x = coord >> 0 & 0xF;
            int y = coord >> 8 & 0xFF;
            int z = coord >> 4 & 0xF;
            this.worldClient.setBlockAndMetadataWithNotify(x + xBase, y, z + zBase, type, data);
            this.worldClient.removePositionTypesInBounds(x + xBase, y, z + zBase, x + xBase, y, z + zBase);
            this.worldClient.markBlocksDirty(x + xBase, y, z + zBase, x + xBase, y, z + zBase);
        }
    }

    @Override
    public void handleMapChunk(BlockRegionUpdatePacket blockRegionUpdatePacket) {
        this.worldClient.removePositionTypesInBounds(blockRegionUpdatePacket.xPosition, blockRegionUpdatePacket.yPosition, blockRegionUpdatePacket.zPosition, blockRegionUpdatePacket.xPosition + blockRegionUpdatePacket.xSize - 1, blockRegionUpdatePacket.yPosition + blockRegionUpdatePacket.ySize - 1, blockRegionUpdatePacket.zPosition + blockRegionUpdatePacket.zSize - 1);
        this.worldClient.setChunkData(blockRegionUpdatePacket.xPosition, blockRegionUpdatePacket.yPosition, blockRegionUpdatePacket.zPosition, blockRegionUpdatePacket.xSize, blockRegionUpdatePacket.ySize, blockRegionUpdatePacket.zSize, blockRegionUpdatePacket.chunk);
    }

    @Override
    public void handleBlockUpdate(BlockUpdatePacket blockUpdatePacket) {
        this.worldClient.blockChange(blockUpdatePacket.xPosition, blockUpdatePacket.yPosition, blockUpdatePacket.zPosition, blockUpdatePacket.blockId, blockUpdatePacket.metadata);
    }

    @Override
    public void handleKickDisconnect(DisconnectPacket packet255KickdisconnectPacket) {
        this.netManager.networkShutdown("disconnect.kicked", new Object[0]);
        this.disconnected = true;
        this.mc.changeWorld(null);
        this.mc.displayScreen(new ConnectFailedScreen("disconnect.disconnected", "disconnect.genericReason", new Object[]{packet255KickdisconnectPacket.reason}));
    }

    @Override
    public void handleErrorMessage(String message, Object[] objects) {
        if (!this.disconnected) {
            this.disconnected = true;
            try {
                this.mc.changeWorld(null);
            }
            catch (Exception e) {
                LOGGER.error("Exception when leaving world!", e);
            }
            try {
                this.mc.displayScreen(null);
            }
            catch (Exception e) {
                LOGGER.error("Exception when leaving GUI!", e);
            }
            this.mc.displayScreen(new ConnectFailedScreen("disconnect.lost", message, objects));
        }
    }

    public void sendFinalPacket(Packet packet) {
        if (!this.disconnected) {
            this.netManager.addToSendQueue(packet);
            this.netManager.serverShutdown();
        }
    }

    public void addToSendQueue(Packet packet) {
        if (!this.disconnected) {
            this.netManager.addToSendQueue(packet);
        }
    }

    @Override
    public void handleCollect(TakeItemEntityPacket takeItemEntityPacket) {
        Entity item = this.getEntityByID(takeItemEntityPacket.collectedEntityId);
        Entity collector = this.getEntityByID(takeItemEntityPacket.collectorEntityId);
        if (collector == null) {
            collector = this.mc.thePlayer;
        }
        if (item != null) {
            this.worldClient.playSoundAtEntity(null, item, "random.pop", 0.2f, ((this.rand.nextFloat() - this.rand.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            this.mc.particleEngine.add(new TakeAnimationParticle(this.mc.theWorld, item, collector, -0.5f));
            this.worldClient.removeEntityFromWorld(takeItemEntityPacket.collectedEntityId);
        }
    }

    @Override
    public void handleChat(ChatPacket packet) {
        String message;
        if (packet.encrypted) {
            try {
                message = AES.decrypt(packet.message, AES.clientKeyChain);
            }
            catch (Exception e) {
                throw new RuntimeException("This crash is caused by outdated Java, please update to 8u161 or newer! If your Java version is out of date due to a technical requirement, please add the JCE Unlimited Strength Jurisdiction Policy Files to your installation. https://www.oracle.com/java/technologies/javase-jce-all-downloads.html", e);
            }
        } else {
            message = packet.message;
        }
        int type = packet.type;
        if (type == 1) {
            this.mc.ingameHud.heldItemTooltipElement.setString(message);
        } else {
            this.mc.ingameHud.addChatMessage(message);
        }
    }

    public void handlePlayerJoin(ChatPacket chatPacket) {
        this.mc.ingameHud.addChatMessage(chatPacket.message);
    }

    public void handlePlayerLeave(ChatPacket chatPacket) {
        this.mc.ingameHud.addChatMessage(chatPacket.message);
    }

    @Override
    public void handleAnimation(AnimatePacket animatePacket) {
        Entity entity = this.getEntityByID(animatePacket.entityId);
        if (entity == null) {
            return;
        }
        if (animatePacket.animate == 1) {
            Player entityplayer = (Player)entity;
            entityplayer.swingItem();
        } else if (animatePacket.animate == 2) {
            entity.animateHurt();
        } else if (animatePacket.animate == 3) {
            Player player = (Player)entity;
            player.wakeUpPlayer(false, false);
        } else if (animatePacket.animate == 4) {
            Player player = (Player)entity;
            player.animate4();
        }
    }

    @Override
    public void handleSleep(SleepPacket sleepPacket) {
        Entity entity = this.getEntityByID(sleepPacket.entityID);
        if (entity == null) {
            return;
        }
        if (sleepPacket.field_22046_e == 0) {
            Player entityplayer = (Player)entity;
            entityplayer.sleepInBedAt(sleepPacket.x, sleepPacket.y, sleepPacket.z);
        }
    }

    @Override
    public void handleHandshake(PreLoginPacket preLoginPacket) {
        block8: {
            if (preLoginPacket.username.equals("-")) {
                try {
                    RSA.RSAKeyChain = RSA.generateKeyPair();
                    this.addToSendQueue(new LoginPacket(this.mc.session.username, this.mc.session.uuid, 29184, RSA.getPublicKey(RSA.RSAKeyChain.getPublic())));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                URL url = new URL("http://session.minecraft.net/game/joinserver.jsp?user=" + this.mc.session.username + "&sessionId=" + this.mc.session.sessionId + "&serverId=" + preLoginPacket.username);
                BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(url.openStream()));
                String s = bufferedreader.readLine();
                bufferedreader.close();
                if (s.equalsIgnoreCase("ok")) {
                    try {
                        RSA.RSAKeyChain = RSA.generateKeyPair();
                        this.addToSendQueue(new LoginPacket(this.mc.session.username, this.mc.session.uuid, 29184, RSA.getPublicKey(RSA.RSAKeyChain.getPublic())));
                        break block8;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Exception while creating LoginPacket!", e);
                    }
                }
                this.netManager.networkShutdown("disconnect.loginFailedInfo", new Object[]{s});
            }
            catch (Exception exception) {
                LOGGER.error("Login Exception!", exception);
                this.netManager.networkShutdown("disconnect.genericReason", new Object[]{"Internal client error: " + exception});
            }
        }
    }

    @Override
    public void handleSendKey(AESSendKeyPacket AESSendKeyPacket2) {
        try {
            AES.clientKeyChain = AES.getKey(RSA.decrypt(AESSendKeyPacket2.KEY, RSA.RSAKeyChain.getPrivate()));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get AES key!", e);
        }
    }

    @Override
    public void handlePlayerList(PlayerListPacket playerListPacket) {
        this.playerList.clear();
        String[] players = playerListPacket.players;
        String[] scores = playerListPacket.scores;
        for (int i = 0; i < players.length; ++i) {
            this.playerList.put(players[i], scores[i]);
        }
    }

    public void disconnect() {
        this.disconnected = true;
        this.netManager.wakeThreads();
        this.netManager.networkShutdown("disconnect.closed", new Object[0]);
    }

    @Override
    public void handleMobSpawn(AddMobPacket addMobPacket) {
        double d = (double)addMobPacket.x / 32.0;
        double d1 = (double)addMobPacket.y / 32.0;
        double d2 = (double)addMobPacket.z / 32.0;
        float f = (float)(addMobPacket.yaw * 360) / 256.0f;
        float f1 = (float)(addMobPacket.pitch * 360) / 256.0f;
        Mob mob = (Mob)EntityDispatcher.createEntity(addMobPacket.type, this.mc.theWorld);
        mob.serverPosX = addMobPacket.x;
        mob.serverPosY = addMobPacket.y;
        mob.serverPosZ = addMobPacket.z;
        mob.id = addMobPacket.id;
        mob.absMoveTo(d, d1, d2, f, f1);
        mob.isMultiplayerEntity = true;
        this.worldClient.addEntityToWorld(addMobPacket.id, mob);
        List<SynchedEntityData.DataItem<?>> list = addMobPacket.getUnpackedData();
        if (list != null) {
            mob.getEntityData().assignValues(list);
        }
        mob.nickname = StringUtils.substring(addMobPacket.nickname, 0, 32);
        mob.chatColor = addMobPacket.chatColor;
    }

    @Override
    public void handleUpdateTime(SetTimePacket setTimePacket) {
        this.mc.theWorld.setWorldTime(setTimePacket.time);
    }

    @Override
    public void handleSpawnPosition(SetSpawnPositionPacket setSpawnPositionPacket) {
        this.mc.thePlayer.setPlayerSpawnCoordinate(new ChunkCoordinates(setSpawnPositionPacket.x, setSpawnPositionPacket.y, setSpawnPositionPacket.z));
        this.mc.theWorld.getLevelData().setSpawn(setSpawnPositionPacket.x, setSpawnPositionPacket.y, setSpawnPositionPacket.z);
    }

    @Override
    public void handleAttachEntity(SetRidingPacket setRidingPacket) {
        Entity passenger = this.getEntityByID(setRidingPacket.passengerId);
        if (setRidingPacket.passengerId == this.mc.thePlayer.id) {
            passenger = this.mc.thePlayer;
        }
        IVehicle vehicle = setRidingPacket.isTileEntity ? (IVehicle)((Object)this.worldClient.getBlockEntity(setRidingPacket.x, setRidingPacket.y, setRidingPacket.z)) : this.getEntityByID(setRidingPacket.vehicleId);
        if (passenger != null && vehicle != null) {
            passenger.startRiding(vehicle);
        }
    }

    @Override
    public void handleEntityStatus(EnitityEventPacket enitityEventPacket) {
        Entity entity = this.getEntityByID(enitityEventPacket.entityId);
        if (entity != null) {
            entity.handleEntityEvent(enitityEventPacket.entityStatus, enitityEventPacket.attackedAtYaw);
        }
    }

    protected Entity getEntityByID(int i) {
        if (i == this.mc.thePlayer.id) {
            return this.mc.thePlayer;
        }
        return this.worldClient.getEntityFromId(i);
    }

    @Override
    public void handleUpdateHealth(SetHealthPacket setHealthPacket) {
        this.mc.thePlayer.setHealth(setHealthPacket.healthMP);
    }

    @Override
    public void handleUpdatePlayerProfile(UpdatePlayerProfilePacket profilePacket) {
        int index;
        PlayerProfile playerProfile = new PlayerProfile(profilePacket.username, profilePacket.nickname, profilePacket.uuid, profilePacket.score, profilePacket.chatColor, profilePacket.isOperator);
        if (playerProfile.uuid.equals(this.mc.thePlayer.uuid)) {
            this.mc.thePlayer.score = playerProfile.scoreTotal;
        }
        if ((index = this.findPlayerInList(playerProfile)) != -1) {
            if (!profilePacket.isOnline) {
                this.removePlayer(index);
            } else {
                this.players.set(index, playerProfile);
            }
        } else {
            this.addPlayer(playerProfile);
        }
    }

    @Override
    public void handleRespawn(RespawnPacket respawnPacket) {
        if (respawnPacket.respawnDimensionId != this.mc.thePlayer.dimension) {
            this.started = false;
            this.worldClient = new WorldClient(this.mc, this, this.worldClient.getLevelData().getRandomSeed(), respawnPacket.respawnDimensionId, respawnPacket.respawnWorldTypeId);
            this.worldClient.isClientSide = true;
            this.mc.changeWorld(this.worldClient);
            this.mc.thePlayer.dimension = respawnPacket.respawnDimensionId;
            this.mc.displayScreen(new DownloadTerrainScreen(this));
        }
        this.mc.respawn(true, respawnPacket.respawnDimensionId);
    }

    @Override
    public void handleExplosion(ExplosionPacket explosionPacket) {
        Explosion explosion = explosionPacket.isCannonball ? new ExplosionCannonball(this.mc.theWorld, null, explosionPacket.explosionX, explosionPacket.explosionY, explosionPacket.explosionZ, explosionPacket.explosionSize) : new Explosion(this.mc.theWorld, null, explosionPacket.explosionX, explosionPacket.explosionY, explosionPacket.explosionZ, explosionPacket.explosionSize);
        explosion.destroyedBlockPositions = explosionPacket.destroyedBlockPositions;
        explosion.addEffects(true);
    }

    @Override
    public void handleOpenWindow(ContainerOpenPacket containerOpenPacket) {
        switch (containerOpenPacket.inventoryType) {
            case 0: {
                SimpleContainer simpleContainer = new SimpleContainer(containerOpenPacket.windowTitle, containerOpenPacket.slotsCount);
                this.mc.thePlayer.displayContainerScreen(simpleContainer);
                this.mc.thePlayer.craftingInventory.containerId = containerOpenPacket.windowId;
                break;
            }
            case 2: {
                FurnaceBlockEntity furnaceBlockEntity = new FurnaceBlockEntity();
                this.mc.thePlayer.displayFurnaceScreen(furnaceBlockEntity);
                this.mc.thePlayer.craftingInventory.containerId = containerOpenPacket.windowId;
                break;
            }
            case 3: {
                DispenserBlockEntity dispenserBlockEntity = new DispenserBlockEntity();
                this.mc.thePlayer.displayDispenserScreen(dispenserBlockEntity);
                this.mc.thePlayer.craftingInventory.containerId = containerOpenPacket.windowId;
                break;
            }
            case 6: {
                ActivatorBlockEntity activatorBlockEntity = new ActivatorBlockEntity();
                this.mc.thePlayer.displayActivatorScreen(activatorBlockEntity);
                this.mc.thePlayer.craftingInventory.containerId = containerOpenPacket.windowId;
                break;
            }
            case 4: {
                BlastFurnaceBlockEntity blastFurnaceBlockEntity = new BlastFurnaceBlockEntity();
                this.mc.thePlayer.displayFurnaceScreen(blastFurnaceBlockEntity);
                this.mc.thePlayer.craftingInventory.containerId = containerOpenPacket.windowId;
                break;
            }
            case 5: {
                TrommelBlockEntity trommelBlockEntity = new TrommelBlockEntity();
                this.mc.thePlayer.displayTrommelScreen(trommelBlockEntity);
                this.mc.thePlayer.craftingInventory.containerId = containerOpenPacket.windowId;
                break;
            }
            case 7: {
                this.mc.thePlayer.displayPaintingPickerScreen();
                break;
            }
            case 1: {
                LocalPlayer localPlayer = this.mc.thePlayer;
                this.mc.thePlayer.displayWorkbenchScreen(MathHelper.floor(localPlayer.x), MathHelper.floor(localPlayer.y), MathHelper.floor(localPlayer.z));
                this.mc.thePlayer.craftingInventory.containerId = containerOpenPacket.windowId;
                break;
            }
            default: {
                LOGGER.warn("No defined before for container open '{}' with type {}!", (Object)containerOpenPacket.windowId, (Object)containerOpenPacket.inventoryType);
            }
        }
    }

    @Override
    public void handleOpenFlagWindow(FlagOpenPacket flagOpenPacket) {
        BlockEntity blockEntity = this.worldClient.getBlockEntity(flagOpenPacket.x, flagOpenPacket.y, flagOpenPacket.z);
        if (blockEntity instanceof FlagBlockEntity) {
            FlagBlockEntity tileEntityFlag = (FlagBlockEntity)blockEntity;
            this.mc.thePlayer.displayFlagEditorScreen(tileEntityFlag);
            this.mc.thePlayer.craftingInventory.containerId = flagOpenPacket.windowId;
        }
    }

    @Override
    public void handlePhotoMode(PhotoModePacket photoModePacket) {
        PauseScreen.photoModeDisabled = photoModePacket.disabled;
    }

    @Override
    public void handleSetSlot(ContainerSetSlotPacket containerSetslotPacket) {
        if (containerSetslotPacket.windowId == -1) {
            this.mc.thePlayer.inventory.setHeldItemStack(containerSetslotPacket.myItemStack);
        } else if (containerSetslotPacket.windowId == 0 && containerSetslotPacket.itemSlot >= 36 && containerSetslotPacket.itemSlot < 45) {
            ItemStack itemstack = this.mc.thePlayer.inventorySlots.getSlot(containerSetslotPacket.itemSlot).getItem();
            if (containerSetslotPacket.myItemStack != null && (itemstack == null || itemstack.stackSize < containerSetslotPacket.myItemStack.stackSize)) {
                containerSetslotPacket.myItemStack.animationsToGo = 5;
            }
            this.mc.thePlayer.inventorySlots.setItem(containerSetslotPacket.itemSlot, containerSetslotPacket.myItemStack);
        } else if (containerSetslotPacket.windowId == this.mc.thePlayer.craftingInventory.containerId) {
            this.mc.thePlayer.craftingInventory.setItem(containerSetslotPacket.itemSlot, containerSetslotPacket.myItemStack);
        }
    }

    @Override
    public void handleTransaction(ContainerAckPacket containerAckPacket) {
        AbstractContainerMenu container = null;
        if (containerAckPacket.windowId == 0) {
            container = this.mc.thePlayer.inventorySlots;
        } else if (containerAckPacket.windowId == this.mc.thePlayer.craftingInventory.containerId) {
            container = this.mc.thePlayer.craftingInventory;
        }
        if (container != null) {
            if (containerAckPacket.accepted) {
                container.deleteBackup(containerAckPacket.shortWindowId);
            } else {
                container.rollbackToBackup(containerAckPacket.shortWindowId);
                this.addToSendQueue(new ContainerAckPacket(containerAckPacket.windowId, containerAckPacket.shortWindowId, true));
            }
        }
    }

    @Override
    public void handleWindowItems(ContainerSetContentPacket containerSetContentPacket) {
        if (containerSetContentPacket.windowId == 0) {
            this.mc.thePlayer.inventorySlots.setAll(containerSetContentPacket.stackList);
        } else if (containerSetContentPacket.windowId == this.mc.thePlayer.craftingInventory.containerId) {
            this.mc.thePlayer.craftingInventory.setAll(containerSetContentPacket.stackList);
        }
    }

    @Override
    public void handleUpdateProgressbar(ContainerSetDataPacket containerSetDataPacket) {
        this.handleInvalidPacket(containerSetDataPacket);
        if (this.mc.thePlayer.craftingInventory != null && this.mc.thePlayer.craftingInventory.containerId == containerSetDataPacket.windowId) {
            this.mc.thePlayer.craftingInventory.setData(containerSetDataPacket.progressBar, containerSetDataPacket.progressBarValue);
        }
    }

    @Override
    public void handlePlayerInventory(SetEquippedItemPacket setEquippedItemPacket) {
        Entity entity = this.getEntityByID(setEquippedItemPacket.entityID);
        if (entity != null) {
            entity.setEquippedSlot(setEquippedItemPacket.slot, setEquippedItemPacket.itemID, setEquippedItemPacket.itemMeta, setEquippedItemPacket.itemData);
        }
    }

    @Override
    public void handlePlayerHeldObject(SetHeldObjectPacket setHeldObjectPacket) {
        Entity entity = this.getEntityByID(setHeldObjectPacket.entityID);
        if (entity != null) {
            entity.setHeldObject(setHeldObjectPacket.objectTag == null ? null : ICarriable.createAndLoadCarriable(entity, setHeldObjectPacket.objectTag));
        }
    }

    @Override
    public void handleCloseWindow(ContainerClosePacket containerClosePacket) {
        this.mc.thePlayer.closeScreen();
    }

    @Override
    public void handleBlockEvent(BlockEventPacket blockEventPacket) {
        this.mc.theWorld.triggerEvent(blockEventPacket.xLocation, blockEventPacket.yLocation, blockEventPacket.zLocation, blockEventPacket.index, blockEventPacket.data);
    }

    @Override
    public void handleBed(BedMessagePacket bedMessagePacket) {
        int state = bedMessagePacket.bedState;
        if (state >= 0 && state < BedMessagePacket.BED_MESSAGE_KEYS.length && BedMessagePacket.BED_MESSAGE_KEYS[state] != null) {
            this.mc.thePlayer.sendTranslatedChatMessage(BedMessagePacket.BED_MESSAGE_KEYS[state]);
        }
    }

    @Override
    public void handleMapData(MapDataPacket mapdataPacket) {
        if (mapdataPacket.itemId == Items.MAP.id) {
            MapItem.getOrCreateSavedData(mapdataPacket.meta, mapdataPacket.scale, this.mc.theWorld).setColors(mapdataPacket.mapData);
        } else {
            LOGGER.warn("Unexpected itemId: {}", (Object)mapdataPacket.itemId);
        }
    }

    @Override
    public void handlePlaySoundEffect(PlaySoundEffectPacket playSoundEffectPacket) {
        this.mc.theWorld.playBlockEvent(playSoundEffectPacket.soundID, playSoundEffectPacket.x, playSoundEffectPacket.y, playSoundEffectPacket.z, playSoundEffectPacket.data);
    }

    @Override
    public void handlePlaySoundDirectly(PlaySoundEffectDirectPacket packet) {
        String soundPath = SoundTypes.getSoundById(packet.soundId);
        if (soundPath == null) {
            return;
        }
        this.mc.sndManager.playSoundAt(soundPath, packet.soundType, (float)packet.x, (float)packet.y, (float)packet.z, packet.volume, packet.pitch);
    }

    @Override
    public void handleSpawnParticle(AddParticlePacket addParticlePacket) {
        if (addParticlePacket.isGroup) {
            for (int i = 0; i < addParticlePacket.amount; ++i) {
                this.mc.renderGlobal.addParticle(addParticlePacket.particleKey, addParticlePacket.x + this.rand.nextDouble() * (double)addParticlePacket.randOffX, addParticlePacket.y + this.rand.nextDouble() * (double)addParticlePacket.randOffY, addParticlePacket.z + this.rand.nextDouble() * (double)addParticlePacket.randOffZ, addParticlePacket.motionX + this.rand.nextGaussian() * (double)addParticlePacket.randMotionX, addParticlePacket.motionY + this.rand.nextGaussian() * (double)addParticlePacket.randMotionY, addParticlePacket.motionZ + this.rand.nextGaussian() * (double)addParticlePacket.randMotionZ, addParticlePacket.data, addParticlePacket.maxDistance);
            }
        } else {
            this.mc.renderGlobal.addParticle(addParticlePacket.particleKey, addParticlePacket.x, addParticlePacket.y, addParticlePacket.z, addParticlePacket.motionX, addParticlePacket.motionY, addParticlePacket.motionZ, addParticlePacket.data, addParticlePacket.maxDistance);
        }
    }

    @Override
    public void handleStatistic(StatisticPacket statisticPacket) {
        this.mc.thePlayer.addStat(StatList.getStat(statisticPacket.statID), statisticPacket.valueChange);
    }

    @Override
    public void handleEntityPlayerGamemode(PlayerGamemodePacket packet) {
        Entity entity = this.getEntityByID(packet.entityId);
        if (entity instanceof Player) {
            ((Player)entity).setGamemode(Gamemode.gamemodesList[packet.gamemodeId]);
        }
    }

    @Override
    public void handleEntityNickname(EntityNicknamePacket entityNicknamePacket) {
        Entity entity = this.getEntityByID(entityNicknamePacket.entityId);
        if (entity instanceof Mob) {
            ((Mob)entity).nickname = StringUtils.substring(entityNicknamePacket.nickname, 0, 32);
            ((Mob)entity).chatColor = entityNicknamePacket.chatColor;
        }
    }

    @Override
    public boolean isServerHandler() {
        return false;
    }

    @Override
    public void handleBlockItemSwitch(SetCarriedItemPacket setCarriedItemPacket) {
        this.mc.thePlayer.inventory.setCurrentItemIndex(setCarriedItemPacket.id, true);
    }

    @Override
    public void handleTileEntityData(BlockEntityDataPacket blockEntityDataPacket) {
        Class<? extends BlockEntity> clazz = BlockEntityDispatcher.getClassFromID(blockEntityDataPacket.tag.getString("id"));
        if (clazz == null) {
            return;
        }
        BlockEntity existingBlockEntity = this.worldClient.getBlockEntity(blockEntityDataPacket.tag.getInteger("x"), blockEntityDataPacket.tag.getInteger("y"), blockEntityDataPacket.tag.getInteger("z"));
        if (existingBlockEntity == null || existingBlockEntity.getClass() != clazz) {
            BlockEntity blockEntity = BlockEntityDispatcher.createAndLoadEntity(blockEntityDataPacket.tag);
            if (blockEntity != null) {
                this.mc.theWorld.setBlockTileEntity(blockEntity.x, blockEntity.y, blockEntity.z, blockEntity);
            }
        } else {
            existingBlockEntity.readFromNBT(blockEntityDataPacket.tag);
        }
        this.worldClient.markBlockDirty(blockEntityDataPacket.tag.getInteger("x"), blockEntityDataPacket.tag.getInteger("y"), blockEntityDataPacket.tag.getInteger("z"));
    }

    @Override
    public void handleGameRule(GameRulePacket packet) {
        LevelData levelData = this.mc.theWorld.getLevelData();
        if (packet.getGameRules() != null) {
            levelData.getGameRules().setValues(packet.getGameRules());
        }
    }

    @Override
    public void handleSyncedRecipe(RecipeSyncPacket recipeSyncPacket) {
        if (Registries.RECIPES.getAllSerializableRecipes().isEmpty()) {
            LOGGER.info("Receiving {} recipes from server..", (Object)recipeSyncPacket.maxRecipes);
        }
        DataLoader.loadRecipeFromServer(recipeSyncPacket);
        if ((long)Registries.RECIPES.getAllSerializableRecipes().size() == recipeSyncPacket.maxRecipes) {
            LOGGER.info("All recipes received!");
            Registries.RECIPES.invalidateCaches();
            SearchPage.searchField.setText("_");
            PageManager.searchQuery = SearchQuery.resolve(SearchPage.searchField.getText());
            GuidebookScreen.getPageManager().updatePages();
            SearchPage.searchField.setText("");
            PageManager.searchQuery = SearchQuery.resolve(SearchPage.searchField.getText());
            GuidebookScreen.getPageManager().updatePages();
        }
    }

    @Override
    public void handleIds(SyncIDsPacket syncIDsPacket) {
        SoundTypes.setSoundIds(syncIDsPacket.soundIds);
    }

    @Override
    public void handleCustomPayload(CustomPayloadPacket customPayloadPacket) {
        if ("BTA|RainbowStart".equals(customPayloadPacket.channel)) {
            int rainbowTicks = Byte.toUnsignedInt(customPayloadPacket.data[0]) << 24 | Byte.toUnsignedInt(customPayloadPacket.data[1]) << 16 | Byte.toUnsignedInt(customPayloadPacket.data[2]) << 8 | Byte.toUnsignedInt(customPayloadPacket.data[3]);
            this.worldClient.addRainbow(rainbowTicks);
        }
    }

    @Override
    public void handleCommandManagerPacket(CommandManagerPacket commandManagerPacket) {
        ChatSuggestionsElement.serverSuggestions = commandManagerPacket.suggestions;
    }
}

