/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.render.Font;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.TextureManager;
import net.minecraft.client.render.blockentity.BlockEntityRenderer;
import net.minecraft.client.render.blockentity.FlagBlockEntityRenderer;
import net.minecraft.client.render.blockentity.FlowerJarBlockEntityRenderer;
import net.minecraft.client.render.blockentity.MeshBlockEntityRenderer;
import net.minecraft.client.render.blockentity.MobSpawnerBlockEntityRenderer;
import net.minecraft.client.render.blockentity.PistonBlockEntityRenderer;
import net.minecraft.client.render.blockentity.SignBlockEntityRenderer;
import net.minecraft.client.render.camera.ICamera;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.Global;
import net.minecraft.core.block.entity.BlockEntity;
import net.minecraft.core.block.entity.FlagBlockEntity;
import net.minecraft.core.block.entity.FlowerJarBlockEntity;
import net.minecraft.core.block.entity.GoldMeshBlockEntity;
import net.minecraft.core.block.entity.MobSpawnerBlockEntity;
import net.minecraft.core.block.entity.SignBlockEntity;
import net.minecraft.core.block.piston.MovingPistonBlockEntity;
import net.minecraft.core.world.World;
import org.lwjgl.opengl.GL11;

public class BlockEntityRenderDispatcher {
    private final Map<Class<?>, BlockEntityRenderer<?>> renderers = new HashMap();
    public static BlockEntityRenderDispatcher instance = new BlockEntityRenderDispatcher();
    private Font font;
    public static double renderPosX;
    public static double renderPosY;
    public static double renderPosZ;
    public TextureManager textureManager;
    public World worldObj;
    public ICamera camera;
    public float viewLerpYaw;
    public float viewLerpPitch;
    public double viewLerpPosX;
    public double viewLerpPosY;
    public double viewLerpPosZ;

    private BlockEntityRenderDispatcher() {
        this.renderers.put(SignBlockEntity.class, new SignBlockEntityRenderer());
        this.renderers.put(FlagBlockEntity.class, new FlagBlockEntityRenderer());
        this.renderers.put(MobSpawnerBlockEntity.class, new MobSpawnerBlockEntityRenderer());
        this.renderers.put(MovingPistonBlockEntity.class, new PistonBlockEntityRenderer());
        this.renderers.put(FlowerJarBlockEntity.class, new FlowerJarBlockEntityRenderer());
        this.renderers.put(GoldMeshBlockEntity.class, new MeshBlockEntityRenderer());
        for (BlockEntityRenderer<?> blockEntityRenderer : this.renderers.values()) {
            blockEntityRenderer.setRenderDispatcher(this);
        }
    }

    public <T extends BlockEntity> BlockEntityRenderer<T> getRenderer(Class<? extends BlockEntity> e) {
        BlockEntityRenderer<Object> r = this.renderers.get(e);
        if (r == null && e != BlockEntity.class) {
            r = this.getRenderer((T)((Object)e.getSuperclass()));
            this.renderers.put(e, r);
        }
        return r;
    }

    public <T extends BlockEntity> BlockEntityRenderer<T> getRenderer(T tileEntity) {
        if (tileEntity == null) {
            return null;
        }
        return this.getRenderer((T)((Object)tileEntity.getClass()));
    }

    public <T extends BlockEntity> boolean hasRenderer(T tileEntity) {
        return this.getRenderer(tileEntity) != null;
    }

    public void cacheActiveRenderInfo(World world, TextureManager textureManager, Font font, ICamera camera, float partialTick) {
        if (this.worldObj != world) {
            this.updateRendererWorldCache(world);
        }
        this.textureManager = textureManager;
        this.camera = camera;
        this.font = font;
        this.viewLerpYaw = (float)camera.getYRot(partialTick);
        this.viewLerpPitch = (float)camera.getXRot(partialTick);
        this.viewLerpPosX = (float)camera.getX(partialTick);
        this.viewLerpPosY = (float)camera.getY(partialTick);
        this.viewLerpPosZ = (float)camera.getZ(partialTick);
    }

    public <T extends BlockEntity> void renderTileEntity(Tessellator tessellator, T tileEntity, float partialTick) {
        if (tileEntity.getDistanceFrom(this.viewLerpPosX, this.viewLerpPosY, this.viewLerpPosZ) < 4096.0) {
            float brightness = 1.0f;
            if (LightmapHelper.isLightmapEnabled()) {
                LightmapHelper.setLightmapCoord(this.worldObj.getLightmapCoord(tileEntity.x, tileEntity.y, tileEntity.z, 0));
            } else if (!Global.accessor.isFullbrightEnabled()) {
                brightness = this.worldObj.getLightBrightness(tileEntity.x, tileEntity.y, tileEntity.z);
            }
            GL11.glColor3f(brightness, brightness, brightness);
            this.renderTileEntity(tessellator, tileEntity, (double)tileEntity.x - renderPosX, (double)tileEntity.y - renderPosY, (double)tileEntity.z - renderPosZ, partialTick);
        }
    }

    public <T extends BlockEntity> void renderTileEntity(Tessellator tessellator, T tileEntity, double x, double y, double z, float partialTick) {
        BlockEntityRenderer<T> renderer = this.getRenderer(tileEntity);
        if (renderer != null) {
            renderer.doRender(tessellator, tileEntity, x, y, z, partialTick);
        }
    }

    public void updateRendererWorldCache(World world) {
        this.worldObj = world;
        for (BlockEntityRenderer<?> renderer : this.renderers.values()) {
            if (renderer == null) continue;
            renderer.onWorldChanged(world);
        }
    }

    public Font getFont() {
        return this.font;
    }
}

