/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.option.GameSettings;
import net.minecraft.client.render.Font;
import net.minecraft.client.render.ItemRenderer;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.TextureManager;
import net.minecraft.client.render.camera.ICamera;
import net.minecraft.client.render.entity.ArmoredZombieRenderer;
import net.minecraft.client.render.entity.ArrowRenderer;
import net.minecraft.client.render.entity.BipedRenderer;
import net.minecraft.client.render.entity.BoatRenderer;
import net.minecraft.client.render.entity.CannonballRenderer;
import net.minecraft.client.render.entity.ChickenRenderer;
import net.minecraft.client.render.entity.CowRenderer;
import net.minecraft.client.render.entity.CreeperRenderer;
import net.minecraft.client.render.entity.DefaultRenderer;
import net.minecraft.client.render.entity.EntityRenderer;
import net.minecraft.client.render.entity.FallingBlockRenderer;
import net.minecraft.client.render.entity.FireflyRenderer;
import net.minecraft.client.render.entity.FishingBobberRenderer;
import net.minecraft.client.render.entity.GhastRenderer;
import net.minecraft.client.render.entity.GiantRenderer;
import net.minecraft.client.render.entity.HumanRenderer;
import net.minecraft.client.render.entity.ItemEntityRenderer;
import net.minecraft.client.render.entity.LightningBoltRenderer;
import net.minecraft.client.render.entity.MinecartRenderer;
import net.minecraft.client.render.entity.MobRenderer;
import net.minecraft.client.render.entity.PaintingRenderer;
import net.minecraft.client.render.entity.PigRenderer;
import net.minecraft.client.render.entity.PlayerRenderer;
import net.minecraft.client.render.entity.ScorpionRenderer;
import net.minecraft.client.render.entity.SheepRenderer;
import net.minecraft.client.render.entity.SlimeRenderer;
import net.minecraft.client.render.entity.SpiderRenderer;
import net.minecraft.client.render.entity.SpriteRenderer;
import net.minecraft.client.render.entity.SquidRenderer;
import net.minecraft.client.render.entity.TNTRenderer;
import net.minecraft.client.render.entity.WolfRenderer;
import net.minecraft.client.render.model.BipedModel;
import net.minecraft.client.render.model.ChickenModel;
import net.minecraft.client.render.model.CowModel;
import net.minecraft.client.render.model.PigModel;
import net.minecraft.client.render.model.SheepModel;
import net.minecraft.client.render.model.SheepOverlayModel;
import net.minecraft.client.render.model.SheepWoolModel;
import net.minecraft.client.render.model.SkeletonModel;
import net.minecraft.client.render.model.SlimeModel;
import net.minecraft.client.render.model.SquidModel;
import net.minecraft.client.render.model.WolfModel;
import net.minecraft.client.render.model.ZombieModel;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.Global;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.FallingBlockEntity;
import net.minecraft.core.entity.FishingBobberEntity;
import net.minecraft.core.entity.ItemEntity;
import net.minecraft.core.entity.LightningEntity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.PaintingEntity;
import net.minecraft.core.entity.TNTPrimedEntity;
import net.minecraft.core.entity.animal.ChickenMob;
import net.minecraft.core.entity.animal.CowMob;
import net.minecraft.core.entity.animal.FireflyClusterMob;
import net.minecraft.core.entity.animal.PigMob;
import net.minecraft.core.entity.animal.SheepMob;
import net.minecraft.core.entity.animal.SquidMob;
import net.minecraft.core.entity.animal.WolfMob;
import net.minecraft.core.entity.monster.CreeperMob;
import net.minecraft.core.entity.monster.GhastMob;
import net.minecraft.core.entity.monster.GiantMob;
import net.minecraft.core.entity.monster.HumanMob;
import net.minecraft.core.entity.monster.ScorpionMob;
import net.minecraft.core.entity.monster.SkeletonMob;
import net.minecraft.core.entity.monster.SlimeMob;
import net.minecraft.core.entity.monster.SnowmanMob;
import net.minecraft.core.entity.monster.SpiderMob;
import net.minecraft.core.entity.monster.ZombieArmoredMob;
import net.minecraft.core.entity.monster.ZombieMob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.entity.projectile.ArrowProjectile;
import net.minecraft.core.entity.projectile.CannonballProjectile;
import net.minecraft.core.entity.projectile.EggProjectile;
import net.minecraft.core.entity.projectile.FireballProjectile;
import net.minecraft.core.entity.projectile.PebbleProjectile;
import net.minecraft.core.entity.projectile.SnowballProjectile;
import net.minecraft.core.entity.vehicle.BoatEntity;
import net.minecraft.core.entity.vehicle.MinecartEntity;
import net.minecraft.core.item.Items;
import net.minecraft.core.world.World;
import org.lwjgl.opengl.GL11;

public class EntityRenderDispatcher {
    private final Map<Class<?>, EntityRenderer<?>> renderers = new HashMap();
    public static EntityRenderDispatcher instance = new EntityRenderDispatcher();
    private Font font;
    public static double renderPosX;
    public static double renderPosY;
    public static double renderPosZ;
    public TextureManager textureManager;
    public ItemRenderer itemRenderer;
    public World world;
    public ICamera camera;
    public float viewLerpYaw;
    public float viewLerpPitch;
    public GameSettings gameSettings;
    public double viewLerpPosX;
    public double viewLerpPosY;
    public double viewLerpPosZ;

    private EntityRenderDispatcher() {
        this.renderers.put(SpiderMob.class, new SpiderRenderer());
        this.renderers.put(ScorpionMob.class, new ScorpionRenderer());
        this.renderers.put(PigMob.class, new PigRenderer(new PigModel(), new PigModel(0.5f), 0.7f));
        this.renderers.put(SheepMob.class, new SheepRenderer(new SheepModel(), new SheepWoolModel(), new SheepOverlayModel(), 0.7f));
        this.renderers.put(CowMob.class, new CowRenderer(new CowModel(), 0.7f));
        this.renderers.put(WolfMob.class, new WolfRenderer(new WolfModel(0.0f), 0.5f));
        this.renderers.put(ChickenMob.class, new ChickenRenderer(new ChickenModel(), 0.3f));
        this.renderers.put(CreeperMob.class, new CreeperRenderer());
        this.renderers.put(SkeletonMob.class, new BipedRenderer(new SkeletonModel(), 0.5f));
        this.renderers.put(ZombieMob.class, new BipedRenderer(new ZombieModel(), 0.5f));
        this.renderers.put(SnowmanMob.class, new BipedRenderer(new ZombieModel(), 0.5f));
        this.renderers.put(ZombieArmoredMob.class, new ArmoredZombieRenderer(new ZombieModel(), 0.5f));
        this.renderers.put(SlimeMob.class, new SlimeRenderer(new SlimeModel(16), new SlimeModel(0), 0.25f));
        this.renderers.put(Player.class, new PlayerRenderer());
        this.renderers.put(HumanMob.class, new HumanRenderer());
        this.renderers.put(GiantMob.class, new GiantRenderer(new ZombieModel(), 0.5f, 6.0f));
        this.renderers.put(GhastMob.class, new GhastRenderer());
        this.renderers.put(SquidMob.class, new SquidRenderer(new SquidModel(), 0.7f));
        this.renderers.put(Mob.class, new MobRenderer(new BipedModel(), 0.5f));
        this.renderers.put(Entity.class, new DefaultRenderer());
        this.renderers.put(PaintingEntity.class, new PaintingRenderer());
        this.renderers.put(ArrowProjectile.class, new ArrowRenderer());
        this.renderers.put(SnowballProjectile.class, new SpriteRenderer(Items.AMMO_SNOWBALL));
        this.renderers.put(EggProjectile.class, new SpriteRenderer(Items.EGG_CHICKEN));
        this.renderers.put(FireballProjectile.class, new SpriteRenderer(Items.AMMO_FIREBALL).setScale(4.0f).setFullBright());
        this.renderers.put(ItemEntity.class, new ItemEntityRenderer());
        this.renderers.put(TNTPrimedEntity.class, new TNTRenderer());
        this.renderers.put(FallingBlockEntity.class, new FallingBlockRenderer());
        this.renderers.put(MinecartEntity.class, new MinecartRenderer());
        this.renderers.put(BoatEntity.class, new BoatRenderer());
        this.renderers.put(FishingBobberEntity.class, new FishingBobberRenderer());
        this.renderers.put(FireflyClusterMob.class, new FireflyRenderer());
        this.renderers.put(LightningEntity.class, new LightningBoltRenderer());
        this.renderers.put(CannonballProjectile.class, new CannonballRenderer());
        this.renderers.put(PebbleProjectile.class, new SpriteRenderer(Items.AMMO_PEBBLE));
        for (EntityRenderer<?> renderer : this.renderers.values()) {
            renderer.init(this);
        }
    }

    public <T extends Entity> EntityRenderer<T> getRenderer(Class<? extends Entity> e) {
        EntityRenderer<Object> r = this.renderers.get(e);
        if (r == null && e != Entity.class) {
            r = this.getRenderer(e.getSuperclass());
            this.renderers.put(e, r);
        }
        return r;
    }

    public <T extends Entity> EntityRenderer<T> getRenderer(Entity entity) {
        return this.getRenderer(entity.getClass());
    }

    public void cacheActiveRenderInfo(World world, TextureManager textureManager, Font font, ICamera camera, GameSettings gameSettings, float partialTick) {
        this.world = world;
        this.textureManager = textureManager;
        this.gameSettings = gameSettings;
        this.font = font;
        this.camera = camera;
        this.viewLerpYaw = (float)camera.getYRot(partialTick);
        this.viewLerpPitch = (float)camera.getXRot(partialTick);
        this.viewLerpPosX = (float)camera.getX(partialTick);
        this.viewLerpPosY = (float)camera.getY(partialTick);
        this.viewLerpPosZ = (float)camera.getZ(partialTick);
    }

    public <T extends Entity> void renderEntity(Tessellator tessellator, T entity, float partialTick) {
        float brightness;
        double lerpPosX = entity.xo + (entity.x - entity.xo) * (double)partialTick;
        double lerpPosY = entity.yo + (entity.y - entity.yo) * (double)partialTick;
        double lerpPosZ = entity.zo + (entity.z - entity.zo) * (double)partialTick;
        float lerpYaw = entity.yRotO + (entity.yRot - entity.yRotO) * partialTick;
        if (LightmapHelper.isLightmapEnabled()) {
            brightness = 1.0f;
            LightmapHelper.setLightmapCoord(entity.getLightmapCoord(partialTick));
        } else {
            brightness = Global.accessor.isFullbrightEnabled() ? 1.0f : entity.getBrightness(partialTick);
        }
        if (Global.accessor.isFullbrightEnabled()) {
            brightness = 1.0f;
        }
        GL11.glColor3f(brightness, brightness, brightness);
        this.renderEntityWithPosYaw(tessellator, entity, lerpPosX - renderPosX, lerpPosY - renderPosY, lerpPosZ - renderPosZ, lerpYaw, partialTick);
    }

    public <T extends Entity> void renderEntityWithPosYaw(Tessellator tessellator, T entity, double x, double y, double z, float yaw, float partialTick) {
        EntityRenderer<T> renderer = this.getRenderer(entity);
        if (renderer != null) {
            renderer.render(tessellator, entity, x, y, z, yaw, partialTick);
            renderer.postRender(tessellator, entity, x, y, z, yaw, partialTick);
        }
    }

    public <T extends Entity> void renderEntityPreviewWithPosYaw(Tessellator tessellator, T entity, double x, double y, double z, float yaw, float partialTick) {
        EntityRenderer<T> renderer = this.getRenderer(entity);
        if (renderer != null) {
            renderer.renderPreview(tessellator, entity, x, y, z, yaw, partialTick);
        }
    }

    public void unloadEntityRenderers() {
        for (EntityRenderer<?> renderer : this.renderers.values()) {
            renderer.onUnload();
        }
    }

    public void setWorld(World world) {
        this.world = world;
    }

    public double distanceToLerpSquared(double x, double y, double z) {
        double dx = x - this.viewLerpPosX;
        double dy = y - this.viewLerpPosY;
        double dz = z - this.viewLerpPosZ;
        return dx * dx + dy * dy + dz * dz;
    }

    public Font getFont() {
        return this.font;
    }
}

