/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.entity.particle.Particle;
import net.minecraft.client.entity.particle.TerrainParticle;
import net.minecraft.client.render.camera.ICamera;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import org.lwjgl.opengl.GL11;

public final class ParticleEngine {
    public static final int MISC_TEXTURE = 0;
    public static final int TERRAIN_TEXTURE = 1;
    public static final int ITEM_TEXTURE = 2;
    public static final int ENTITY_PARTICLE_TEXTURE = 3;
    public static final int TEXTURE_COUNT = 4;
    private World world;
    private final List<Particle>[] particles = new ArrayList[4];
    private final Random rand = new Random();

    public ParticleEngine(World world) {
        if (world != null) {
            this.world = world;
        }
        for (int i = 0; i < this.particles.length; ++i) {
            this.particles[i] = new ArrayList<Particle>();
        }
    }

    public void add(Particle p) {
        int t = p.getParticleTexture();
        if (this.particles[t].size() >= 4000) {
            this.particles[t].remove(0);
        }
        this.particles[t].add(p);
    }

    public void tick() {
        for (int tt = 0; tt < this.particles.length; ++tt) {
            for (int i = 0; i < this.particles[tt].size(); ++i) {
                Particle p = this.particles[tt].get(i);
                p.tick();
                if (!p.removed) continue;
                this.particles[tt].remove(i--);
            }
        }
    }

    public void renderParticles(ICamera camera, float partialTick) {
        double yRot = camera.getYRot(partialTick);
        double xRot = camera.getXRot(partialTick);
        float xa = MathHelper.cos((float)(yRot * Math.PI) / 180.0f);
        float za = MathHelper.sin((float)(yRot * Math.PI) / 180.0f);
        float xa2 = -za * MathHelper.sin((float)(xRot * Math.PI / 180.0));
        float za2 = xa * MathHelper.sin((float)(xRot * Math.PI / 180.0));
        float ya = MathHelper.cos((float)(xRot * Math.PI / 180.0));
        double xOff = camera.getX(partialTick);
        double yOff = camera.getY(partialTick);
        double zOff = camera.getZ(partialTick);
        for (int tt = 0; tt < 3; ++tt) {
            if (this.particles[tt].isEmpty()) continue;
            int texture = 0;
            if (tt == 0) {
                texture = TextureRegistry.particleAtlas.id();
            }
            if (tt == 1) {
                texture = TextureRegistry.blockAtlas.id();
            }
            if (tt == 2) {
                texture = TextureRegistry.itemAtlas.id();
            }
            GL11.glBindTexture(3553, texture);
            Tessellator tessellator = Tessellator.instance;
            tessellator.startDrawingQuads();
            for (int i = 0; i < this.particles[tt].size(); ++i) {
                Particle p = this.particles[tt].get(i);
                p.render(tessellator, partialTick, xOff, yOff, zOff, xa, ya, za, xa2, za2);
            }
            tessellator.draw();
        }
    }

    public void renderLitParticles(ICamera camera, float partialTick) {
        int tt = 3;
        if (this.particles[tt].isEmpty()) {
            return;
        }
        double xOff = camera.getX(partialTick);
        double yOff = camera.getY(partialTick);
        double zOff = camera.getZ(partialTick);
        Tessellator tessellator = Tessellator.instance;
        for (int i = 0; i < this.particles[tt].size(); ++i) {
            Particle p = this.particles[tt].get(i);
            p.render(tessellator, partialTick, xOff, yOff, zOff, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        }
    }

    public void setWorld(World world) {
        this.world = world;
        for (int i = 0; i < 4; ++i) {
            this.particles[i].clear();
        }
    }

    public void destroy(int x, int y, int z, int id, int data) {
        Block block = Block.blocksList[id];
        if (block == null) {
            return;
        }
        int amount = 4;
        if (block == Blocks.FIRE) {
            return;
        }
        for (int xx = 0; xx < amount; ++xx) {
            for (int yy = 0; yy < amount; ++yy) {
                for (int zz = 0; zz < amount; ++zz) {
                    double xp = (double)x + ((double)xx + 0.5) / (double)amount;
                    double yp = (double)y + ((double)yy + 0.5) / (double)amount;
                    double zp = (double)z + ((double)zz + 0.5) / (double)amount;
                    Side side = Side.getSideById(this.rand.nextInt(6));
                    this.add(new TerrainParticle(this.world, xp, yp, zp, xp - (double)x - 0.5, yp - (double)y - 0.5, zp - (double)z - 0.5, block, side, data).init(x, y, z));
                }
            }
        }
    }

    public void crack(int x, int y, int z, Side side) {
        int id = this.world.getBlockId(x, y, z);
        if (id == 0) {
            return;
        }
        Block block = Block.blocksList[id];
        float r = 0.1f;
        double xp = (double)x + this.rand.nextDouble() * (block.maxX - block.minX - (double)(r * 2.0f)) + (double)r + block.minX;
        double yp = (double)y + this.rand.nextDouble() * (block.maxY - block.minY - (double)(r * 2.0f)) + (double)r + block.minY;
        double zp = (double)z + this.rand.nextDouble() * (block.maxZ - block.minZ - (double)(r * 2.0f)) + (double)r + block.minZ;
        if (side == Side.BOTTOM) {
            yp = (double)y + block.minY - (double)r;
        } else if (side == Side.TOP) {
            yp = (double)y + block.maxY + (double)r;
        } else if (side == Side.NORTH) {
            zp = (double)z + block.minZ - (double)r;
        } else if (side == Side.SOUTH) {
            zp = (double)z + block.maxZ + (double)r;
        } else if (side == Side.WEST) {
            xp = (double)x + block.minX - (double)r;
        } else if (side == Side.EAST) {
            xp = (double)x + block.maxX + (double)r;
        }
        this.add(new TerrainParticle(this.world, xp, yp, zp, 0.0, 0.0, 0.0, block, side, this.world.getBlockMetadata(x, y, z)).init(x, y, z).setPower(0.2f).setScale(0.6f));
    }

    public int countParticles() {
        return this.particles[0].size() + this.particles[1].size() + this.particles[2].size();
    }
}

