/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.RenderBlocks;
import net.minecraft.client.render.block.color.BlockColor;
import net.minecraft.client.render.block.color.BlockColorDispatcher;
import net.minecraft.client.render.block.model.StandardBlockModel;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.ThinFenceBlock;
import net.minecraft.core.util.helper.Direction;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

public class FenceThinBlockModel<T extends ThinFenceBlock>
extends StandardBlockModel<T> {
    private final IconCoordinate texIndex;
    private final IconCoordinate bottomTexIndex;
    private final IconCoordinate topTexIndex;
    private final IconCoordinate columnTexIndex;

    public FenceThinBlockModel(Block block, IconCoordinate texIndex, IconCoordinate bottomTexIndex, IconCoordinate topTexIndex, IconCoordinate columnTexIndex) {
        super(block);
        this.texIndex = texIndex;
        this.bottomTexIndex = bottomTexIndex;
        this.topTexIndex = topTexIndex;
        this.columnTexIndex = columnTexIndex;
    }

    @Override
    public boolean render(Tessellator t, int x, int y, int z) {
        float maxZ;
        float maxY;
        float maxX;
        float minZ;
        float minY;
        float minX;
        double sidesMaxV;
        double sidesMaxU;
        double sidesMinV;
        double sidesMinU;
        boolean connectDownWest;
        ((ThinFenceBlock)this.block).setBlockBoundsBasedOnState(FenceThinBlockModel.renderBlocks.blockAccess, x, y, z);
        float brightness = 1.0f;
        if (LightmapHelper.isLightmapEnabled()) {
            t.setLightmapCoord(((ThinFenceBlock)this.block).getLightmapCoord(FenceThinBlockModel.renderBlocks.blockAccess, x, y, z));
        } else {
            brightness = this.getBlockBrightness(FenceThinBlockModel.renderBlocks.blockAccess, x, y, z);
        }
        t.setColorOpaque_F(brightness, brightness, brightness);
        float cBottom = 1.0f;
        float cTop = 1.0f;
        float cNorthSouth = 1.0f;
        float cEastWest = 1.0f;
        if (RenderBlocks.enableDirectionalLight) {
            cBottom = 0.5f;
            cTop = 1.0f;
            cNorthSouth = 0.8f;
            cEastWest = 0.6f;
        }
        boolean connectNorth = ((ThinFenceBlock)this.block).canConnectTo(FenceThinBlockModel.renderBlocks.blockAccess, x + Direction.NORTH.getOffsetX(), y + Direction.NORTH.getOffsetY(), z + Direction.NORTH.getOffsetZ());
        boolean connectSouth = ((ThinFenceBlock)this.block).canConnectTo(FenceThinBlockModel.renderBlocks.blockAccess, x + Direction.SOUTH.getOffsetX(), y + Direction.SOUTH.getOffsetY(), z + Direction.SOUTH.getOffsetZ());
        boolean connectEast = ((ThinFenceBlock)this.block).canConnectTo(FenceThinBlockModel.renderBlocks.blockAccess, x + Direction.EAST.getOffsetX(), y + Direction.EAST.getOffsetY(), z + Direction.EAST.getOffsetZ());
        boolean connectWest = ((ThinFenceBlock)this.block).canConnectTo(FenceThinBlockModel.renderBlocks.blockAccess, x + Direction.WEST.getOffsetX(), y + Direction.WEST.getOffsetY(), z + Direction.WEST.getOffsetZ());
        boolean lineNorthSouth = connectNorth && connectSouth;
        boolean lineEastWest = connectEast && connectWest;
        double onePix = 0.0625;
        double fenceNormalMinU = this.texIndex.getIconUMin();
        double fenceNormalMinV = this.texIndex.getIconVMin();
        double fenceNormalMaxU = this.texIndex.getSubIconU(onePix * 16.0);
        double fenceNormalMaxV = this.texIndex.getSubIconV(onePix * 16.0);
        IconCoordinate fenceTopmostTex = this.topTexIndex == null ? this.texIndex : this.topTexIndex;
        double fenceTopmostMinU = fenceTopmostTex.getIconUMin();
        double fenceTopmostMinV = fenceTopmostTex.getIconVMin();
        double fenceTopmostMaxU = fenceTopmostTex.getSubIconU(onePix * 16.0);
        double fenceTopmostMaxV = fenceTopmostTex.getSubIconV(onePix * 16.0);
        IconCoordinate fenceBottommostTex = this.bottomTexIndex == null ? this.texIndex : this.bottomTexIndex;
        double fenceBottommostMinU = fenceBottommostTex.getIconUMin();
        double fenceBottommostMinV = fenceBottommostTex.getIconVMin();
        double fenceBottommostMaxU = fenceBottommostTex.getSubIconU(onePix * 16.0);
        double fenceBottommostMaxV = fenceBottommostTex.getSubIconV(onePix * 16.0);
        Block blockAbove = FenceThinBlockModel.renderBlocks.blockAccess.getBlock(x, y + 1, z);
        boolean connectUpNorth = blockAbove == this.block && ((ThinFenceBlock)this.block).canConnectTo(FenceThinBlockModel.renderBlocks.blockAccess, x + Direction.NORTH.getOffsetX(), y + Direction.NORTH.getOffsetY() + 1, z + Direction.NORTH.getOffsetZ());
        boolean connectUpSouth = blockAbove == this.block && ((ThinFenceBlock)this.block).canConnectTo(FenceThinBlockModel.renderBlocks.blockAccess, x + Direction.SOUTH.getOffsetX(), y + Direction.SOUTH.getOffsetY() + 1, z + Direction.SOUTH.getOffsetZ());
        boolean connectUpEast = blockAbove == this.block && ((ThinFenceBlock)this.block).canConnectTo(FenceThinBlockModel.renderBlocks.blockAccess, x + Direction.EAST.getOffsetX(), y + Direction.EAST.getOffsetY() + 1, z + Direction.EAST.getOffsetZ());
        boolean connectUpWest = blockAbove == this.block && ((ThinFenceBlock)this.block).canConnectTo(FenceThinBlockModel.renderBlocks.blockAccess, x + Direction.WEST.getOffsetX(), y + Direction.WEST.getOffsetY() + 1, z + Direction.WEST.getOffsetZ());
        Block blockBelow = FenceThinBlockModel.renderBlocks.blockAccess.getBlock(x, y - 1, z);
        boolean connectDownNorth = blockBelow == this.block && ((ThinFenceBlock)this.block).canConnectTo(FenceThinBlockModel.renderBlocks.blockAccess, x + Direction.NORTH.getOffsetX(), y + Direction.NORTH.getOffsetY() - 1, z + Direction.NORTH.getOffsetZ());
        boolean connectDownSouth = blockBelow == this.block && ((ThinFenceBlock)this.block).canConnectTo(FenceThinBlockModel.renderBlocks.blockAccess, x + Direction.SOUTH.getOffsetX(), y + Direction.SOUTH.getOffsetY() - 1, z + Direction.SOUTH.getOffsetZ());
        boolean connectDownEast = blockBelow == this.block && ((ThinFenceBlock)this.block).canConnectTo(FenceThinBlockModel.renderBlocks.blockAccess, x + Direction.EAST.getOffsetX(), y + Direction.EAST.getOffsetY() - 1, z + Direction.EAST.getOffsetZ());
        boolean bl = connectDownWest = blockBelow == this.block && ((ThinFenceBlock)this.block).canConnectTo(FenceThinBlockModel.renderBlocks.blockAccess, x + Direction.WEST.getOffsetX(), y + Direction.WEST.getOffsetY() - 1, z + Direction.WEST.getOffsetZ());
        if (((ThinFenceBlock)this.block).shouldDrawColumn(FenceThinBlockModel.renderBlocks.blockAccess, x, y, z)) {
            sidesMinU = this.columnTexIndex.getIconUMin();
            sidesMinV = this.columnTexIndex.getIconVMin();
            sidesMaxU = this.columnTexIndex.getSubIconU(onePix * 2.0);
            sidesMaxV = this.columnTexIndex.getSubIconV(onePix * 16.0);
            minX = (float)x + 0.4375f;
            minY = y;
            minZ = (float)z + 0.4375f;
            maxX = (float)x + 0.5625f;
            maxY = (float)y + 1.0f;
            maxZ = (float)z + 0.5625f;
            t.setColorOpaque_F(cNorthSouth * brightness, cNorthSouth * brightness, cNorthSouth * brightness);
            t.addVertexWithUV(maxX, minY, minZ, sidesMinU, sidesMaxV);
            t.addVertexWithUV(minX, minY, minZ, sidesMaxU, sidesMaxV);
            t.addVertexWithUV(minX, maxY, minZ, sidesMaxU, sidesMinV);
            t.addVertexWithUV(maxX, maxY, minZ, sidesMinU, sidesMinV);
            t.addVertexWithUV(minX, minY, maxZ, sidesMinU, sidesMaxV);
            t.addVertexWithUV(maxX, minY, maxZ, sidesMaxU, sidesMaxV);
            t.addVertexWithUV(maxX, maxY, maxZ, sidesMaxU, sidesMinV);
            t.addVertexWithUV(minX, maxY, maxZ, sidesMinU, sidesMinV);
            t.setColorOpaque_F(cEastWest * brightness, cEastWest * brightness, cEastWest * brightness);
            t.addVertexWithUV(maxX, minY, maxZ, sidesMinU, sidesMaxV);
            t.addVertexWithUV(maxX, minY, minZ, sidesMaxU, sidesMaxV);
            t.addVertexWithUV(maxX, maxY, minZ, sidesMaxU, sidesMinV);
            t.addVertexWithUV(maxX, maxY, maxZ, sidesMinU, sidesMinV);
            t.addVertexWithUV(minX, minY, minZ, sidesMinU, sidesMaxV);
            t.addVertexWithUV(minX, minY, maxZ, sidesMaxU, sidesMaxV);
            t.addVertexWithUV(minX, maxY, maxZ, sidesMaxU, sidesMinV);
            t.addVertexWithUV(minX, maxY, minZ, sidesMinU, sidesMinV);
            double topBottomMinU = this.columnTexIndex.getIconUMin();
            double topBottomMinV = this.columnTexIndex.getIconVMin();
            double topBottomMaxU = this.columnTexIndex.getSubIconU(onePix * 2.0);
            double topBottomMaxV = this.columnTexIndex.getSubIconV(onePix * 2.0);
            t.setColorOpaque_F(cTop * brightness, cTop * brightness, cTop * brightness);
            t.addVertexWithUV(minX, maxY, maxZ, topBottomMinU, topBottomMaxV);
            t.addVertexWithUV(maxX, maxY, maxZ, topBottomMaxU, topBottomMaxV);
            t.addVertexWithUV(maxX, maxY, minZ, topBottomMaxU, topBottomMinV);
            t.addVertexWithUV(minX, maxY, minZ, topBottomMinU, topBottomMinV);
            t.setColorOpaque_F(cBottom * brightness, cBottom * brightness, cBottom * brightness);
            t.addVertexWithUV(minX, minY, minZ, topBottomMinU, topBottomMinV);
            t.addVertexWithUV(maxX, minY, minZ, topBottomMaxU, topBottomMinV);
            t.addVertexWithUV(maxX, minY, maxZ, topBottomMaxU, topBottomMaxV);
            t.addVertexWithUV(minX, minY, maxZ, topBottomMinU, topBottomMaxV);
        }
        if (connectNorth) {
            if (this.bottomTexIndex != null && !connectDownNorth) {
                sidesMinU = fenceBottommostMinU;
                sidesMinV = fenceBottommostMinV;
                sidesMaxV = fenceBottommostMaxV;
                sidesMaxU = fenceBottommostTex.getSubIconU(onePix * 8.0);
            } else if (this.topTexIndex != null && !connectUpNorth) {
                sidesMinU = fenceTopmostMinU;
                sidesMinV = fenceTopmostMinV;
                sidesMaxV = fenceTopmostMaxV;
                sidesMaxU = fenceTopmostTex.getSubIconU(onePix * 8.0);
            } else {
                sidesMinU = fenceNormalMinU;
                sidesMinV = fenceNormalMinV;
                sidesMaxV = fenceNormalMaxV;
                sidesMaxU = this.texIndex.getSubIconU(onePix * 8.0);
            }
            minX = (float)x + 0.5f;
            minY = y;
            minZ = z;
            maxX = (float)x + 0.5f;
            maxY = (float)y + 1.0f;
            maxZ = (float)z + 0.5f;
            t.setColorOpaque_F(cEastWest * brightness, cEastWest * brightness, cEastWest * brightness);
            t.addVertexWithUV(maxX, minY, maxZ, sidesMinU, sidesMaxV);
            t.addVertexWithUV(maxX, minY, minZ, sidesMaxU, sidesMaxV);
            t.addVertexWithUV(maxX, maxY, minZ, sidesMaxU, sidesMinV);
            t.addVertexWithUV(maxX, maxY, maxZ, sidesMinU, sidesMinV);
            t.addVertexWithUV(minX, minY, minZ, sidesMaxU, sidesMaxV);
            t.addVertexWithUV(minX, minY, maxZ, sidesMinU, sidesMaxV);
            t.addVertexWithUV(minX, maxY, maxZ, sidesMinU, sidesMinV);
            t.addVertexWithUV(minX, maxY, minZ, sidesMaxU, sidesMinV);
        }
        if (connectSouth) {
            if (this.bottomTexIndex != null && !connectDownSouth) {
                sidesMinU = fenceBottommostTex.getSubIconU(onePix * 8.0);
                sidesMaxU = fenceBottommostTex.getIconUMax();
                sidesMinV = fenceBottommostMinV;
                sidesMaxV = fenceBottommostMaxV;
            } else if (this.topTexIndex != null && !connectUpSouth) {
                sidesMinU = fenceTopmostTex.getSubIconU(onePix * 8.0);
                sidesMaxU = fenceTopmostTex.getIconUMax();
                sidesMinV = fenceTopmostMinV;
                sidesMaxV = fenceTopmostMaxV;
            } else {
                sidesMinU = this.texIndex.getSubIconU(onePix * 8.0);
                sidesMaxU = this.texIndex.getIconUMax();
                sidesMinV = fenceNormalMinV;
                sidesMaxV = fenceNormalMaxV;
            }
            minX = (float)x + 0.5f;
            minY = y;
            minZ = (float)z + 0.5f;
            maxX = (float)x + 0.5f;
            maxY = (float)y + 1.0f;
            maxZ = (float)z + 1.0f;
            t.setColorOpaque_F(cEastWest * brightness, cEastWest * brightness, cEastWest * brightness);
            t.addVertexWithUV(maxX, minY, maxZ, sidesMinU, sidesMaxV);
            t.addVertexWithUV(maxX, minY, minZ, sidesMaxU, sidesMaxV);
            t.addVertexWithUV(maxX, maxY, minZ, sidesMaxU, sidesMinV);
            t.addVertexWithUV(maxX, maxY, maxZ, sidesMinU, sidesMinV);
            t.addVertexWithUV(minX, minY, minZ, sidesMaxU, sidesMaxV);
            t.addVertexWithUV(minX, minY, maxZ, sidesMinU, sidesMaxV);
            t.addVertexWithUV(minX, maxY, maxZ, sidesMinU, sidesMinV);
            t.addVertexWithUV(minX, maxY, minZ, sidesMaxU, sidesMinV);
        }
        if (connectWest) {
            if (this.bottomTexIndex != null && !connectDownWest) {
                sidesMinU = fenceBottommostMinU;
                sidesMinV = fenceBottommostMinV;
                sidesMaxV = fenceBottommostMaxV;
                sidesMaxU = fenceBottommostTex.getSubIconU(onePix * 8.0);
            } else if (this.topTexIndex != null && !connectUpWest) {
                sidesMinU = fenceTopmostMinU;
                sidesMinV = fenceTopmostMinV;
                sidesMaxV = fenceTopmostMaxV;
                sidesMaxU = fenceTopmostTex.getSubIconU(onePix * 8.0);
            } else {
                sidesMinU = fenceNormalMinU;
                sidesMinV = fenceNormalMinV;
                sidesMaxV = fenceNormalMaxV;
                sidesMaxU = this.texIndex.getSubIconU(onePix * 8.0);
            }
            minX = x;
            minY = y;
            minZ = (float)z + 0.5f;
            maxX = (float)x + 0.5f;
            maxY = (float)y + 1.0f;
            maxZ = (float)z + 0.5f;
            t.setColorOpaque_F(cNorthSouth * brightness, cNorthSouth * brightness, cNorthSouth * brightness);
            t.addVertexWithUV(maxX, minY, minZ, sidesMinU, sidesMaxV);
            t.addVertexWithUV(minX, minY, minZ, sidesMaxU, sidesMaxV);
            t.addVertexWithUV(minX, maxY, minZ, sidesMaxU, sidesMinV);
            t.addVertexWithUV(maxX, maxY, minZ, sidesMinU, sidesMinV);
            t.addVertexWithUV(minX, minY, maxZ, sidesMaxU, sidesMaxV);
            t.addVertexWithUV(maxX, minY, maxZ, sidesMinU, sidesMaxV);
            t.addVertexWithUV(maxX, maxY, maxZ, sidesMinU, sidesMinV);
            t.addVertexWithUV(minX, maxY, maxZ, sidesMaxU, sidesMinV);
        }
        if (connectEast) {
            if (this.bottomTexIndex != null && !connectDownEast) {
                sidesMinU = fenceBottommostTex.getSubIconU(onePix * 8.0);
                sidesMaxU = fenceBottommostTex.getIconUMax();
                sidesMinV = fenceBottommostMinV;
                sidesMaxV = fenceBottommostMaxV;
            } else if (this.topTexIndex != null && !connectUpEast) {
                sidesMinU = fenceTopmostTex.getSubIconU(onePix * 8.0);
                sidesMaxU = fenceTopmostTex.getIconUMax();
                sidesMinV = fenceTopmostMinV;
                sidesMaxV = fenceTopmostMaxV;
            } else {
                sidesMinU = this.texIndex.getSubIconU(onePix * 8.0);
                sidesMaxU = this.texIndex.getIconUMax();
                sidesMinV = fenceNormalMinV;
                sidesMaxV = fenceNormalMaxV;
            }
            minX = (float)x + 0.5f;
            minY = y;
            minZ = (float)z + 0.5f;
            maxX = (float)x + 1.0f;
            maxY = (float)y + 1.0f;
            maxZ = (float)z + 0.5f;
            t.setColorOpaque_F(cNorthSouth * brightness, cNorthSouth * brightness, cNorthSouth * brightness);
            t.addVertexWithUV(maxX, minY, minZ, sidesMinU, sidesMaxV);
            t.addVertexWithUV(minX, minY, minZ, sidesMaxU, sidesMaxV);
            t.addVertexWithUV(minX, maxY, minZ, sidesMaxU, sidesMinV);
            t.addVertexWithUV(maxX, maxY, minZ, sidesMinU, sidesMinV);
            t.addVertexWithUV(minX, minY, maxZ, sidesMaxU, sidesMaxV);
            t.addVertexWithUV(maxX, minY, maxZ, sidesMinU, sidesMaxV);
            t.addVertexWithUV(maxX, maxY, maxZ, sidesMinU, sidesMinV);
            t.addVertexWithUV(minX, maxY, maxZ, sidesMaxU, sidesMinV);
        }
        return true;
    }

    @Override
    public void renderBlockOnInventory(Tessellator tessellator, int metadata, float brightness, float alpha, @Nullable Integer lightmapCoordinate) {
        if (FenceThinBlockModel.renderBlocks.useInventoryTint) {
            int j = ((BlockColor)BlockColorDispatcher.getInstance().getDispatch(this.block)).getFallbackColor(metadata);
            float f1 = (float)(j >> 16 & 0xFF) / 255.0f;
            float f3 = (float)(j >> 8 & 0xFF) / 255.0f;
            float f5 = (float)(j & 0xFF) / 255.0f;
            GL11.glColor4f(f1 * brightness, f3 * brightness, f5 * brightness, alpha);
        }
        GL11.glRotatef(90.0f, 0.0f, 1.0f, 0.0f);
        for (int i1 = 0; i1 < 2; ++i1) {
            GL11.glPushMatrix();
            float f4 = 0.0625f;
            ((ThinFenceBlock)this.block).setBlockBounds(0.0, 0.0, 0.0, 2.0f * f4, 1.0, f4 * 2.0f);
            GL11.glTranslatef(0.5f - f4, 0.0f, 0.0f);
            if (i1 == 1) {
                GL11.glTranslatef(0.0f, 0.0f, 1.0f - f4 * 2.0f);
            }
            GL11.glTranslatef(-0.5f, -0.5f, -0.5f);
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, -1.0f, 0.0f);
            this.renderBottomFace(tessellator, this.block, 0.0, 0.0, 0.0, this.columnTexIndex);
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 1.0f, 0.0f);
            this.renderTopFace(tessellator, this.block, 0.0, 0.0, 0.0, this.columnTexIndex);
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 0.0f, -1.0f);
            this.renderNorthFace(tessellator, this.block, 0.0, 0.0, 0.0, this.columnTexIndex);
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 0.0f, 1.0f);
            this.renderSouthFace(tessellator, this.block, 0.0, 0.0, 0.0, this.columnTexIndex);
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(-1.0f, 0.0f, 0.0f);
            this.renderWestFace(tessellator, this.block, 0.0, 0.0, 0.0, this.columnTexIndex);
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(1.0f, 0.0f, 0.0f);
            this.renderEastFace(tessellator, this.block, 0.0, 0.0, 0.0, this.columnTexIndex);
            tessellator.draw();
            GL11.glPopMatrix();
        }
        GL11.glTranslatef(-0.5f, -0.5f, -0.5f);
        GL11.glDisable(2884);
        ((ThinFenceBlock)this.block).setBlockBounds(0.0, 0.0, 0.0, 0.5, 1.0, 1.0);
        tessellator.startDrawingQuads();
        tessellator.setNormal(1.0f, 0.0f, 0.0f);
        this.renderEastFace(tessellator, this.block, 0.0, 0.0, 0.0, this.texIndex);
        tessellator.draw();
        GL11.glTranslatef(0.5f, 0.5f, 0.5f);
        ((ThinFenceBlock)this.block).setBlockBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    }
}

