/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.StandardBlockModel;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.FullRotatableBlock;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import org.jetbrains.annotations.Nullable;

public class FullRotatableBlockModel<T extends FullRotatableBlock>
extends StandardBlockModel<T> {
    public FullRotatableBlockModel(Block block) {
        super(block);
    }

    @Override
    public boolean render(Tessellator tessellator, int x, int y, int z) {
        ((FullRotatableBlock)this.block).setBlockBoundsBasedOnState(FullRotatableBlockModel.renderBlocks.blockAccess, x, y, z);
        int meta = FullRotatableBlockModel.renderBlocks.blockAccess.getBlockMetadata(x, y, z);
        Direction dir = FullRotatableBlock.metaToDirection(meta);
        switch (dir) {
            case DOWN: {
                FullRotatableBlockModel.renderBlocks.uvRotateEast = 3;
                FullRotatableBlockModel.renderBlocks.uvRotateWest = 3;
                FullRotatableBlockModel.renderBlocks.uvRotateSouth = 3;
                FullRotatableBlockModel.renderBlocks.uvRotateNorth = 3;
                break;
            }
            case NORTH: {
                FullRotatableBlockModel.renderBlocks.uvRotateSouth = 1;
                FullRotatableBlockModel.renderBlocks.uvRotateNorth = 2;
                break;
            }
            case SOUTH: {
                FullRotatableBlockModel.renderBlocks.uvRotateSouth = 2;
                FullRotatableBlockModel.renderBlocks.uvRotateNorth = 1;
                FullRotatableBlockModel.renderBlocks.uvRotateTop = 3;
                FullRotatableBlockModel.renderBlocks.uvRotateBottom = 3;
                break;
            }
            case WEST: {
                FullRotatableBlockModel.renderBlocks.uvRotateEast = 1;
                FullRotatableBlockModel.renderBlocks.uvRotateWest = 2;
                FullRotatableBlockModel.renderBlocks.uvRotateTop = 2;
                FullRotatableBlockModel.renderBlocks.uvRotateBottom = 1;
                break;
            }
            case EAST: {
                FullRotatableBlockModel.renderBlocks.uvRotateEast = 2;
                FullRotatableBlockModel.renderBlocks.uvRotateWest = 1;
                FullRotatableBlockModel.renderBlocks.uvRotateTop = 1;
                FullRotatableBlockModel.renderBlocks.uvRotateBottom = 2;
            }
        }
        boolean result = this.renderStandardBlock(tessellator, this.block, x, y, z);
        this.resetRenderBlocks();
        return result;
    }

    @Override
    public void renderBlockOnInventory(Tessellator tessellator, int metadata, float brightness, float alpha, @Nullable Integer lightmapCoordinate) {
        super.renderBlockOnInventory(tessellator, 1, brightness, alpha, lightmapCoordinate);
    }

    @Override
    public IconCoordinate getBlockTextureFromSideAndMetadata(Side side, int data) {
        Direction dir = FullRotatableBlock.metaToDirection(data);
        if (side == dir.getSide()) {
            return this.atlasIndices[Side.TOP.getId()];
        }
        return side.getDirection() != dir.getOpposite() ? this.atlasIndices[Side.NORTH.getId()] : this.atlasIndices[Side.BOTTOM.getId()];
    }
}

