/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.CrossedSquaresBlockModel;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.StackedFlowerBlock;
import net.minecraft.core.util.helper.Side;

public class StackedFlowerBlockModel<T extends StackedFlowerBlock>
extends CrossedSquaresBlockModel<T> {
    private final IconCoordinate[] ICONS = new IconCoordinate[4];

    public StackedFlowerBlockModel(Block block, String baseTexture) {
        super(block);
        for (int i = 0; i < 4; ++i) {
            this.ICONS[i] = TextureRegistry.getTexture(baseTexture + i);
        }
    }

    @Override
    public IconCoordinate getBlockTextureFromSideAndMetadata(Side side, int data) {
        int stackCount = StackedFlowerBlock.getStackCount(data);
        if (stackCount > 3) {
            return this.ICONS[0];
        }
        return this.ICONS[stackCount];
    }
}

