/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.StandardBlockModel;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.TrapDoorBlock;
import net.minecraft.core.util.helper.Axis;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.helper.Sides;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

public class TrapDoorBlockModel<T extends Block>
extends StandardBlockModel<T> {
    public TrapDoorBlockModel(Block block) {
        super(block);
        float offset = 0.1875f;
        this.withCustomItemBounds(0.0, 0.0, 0.0, 1.0, offset, 1.0);
    }

    @Override
    public boolean render(Tessellator tessellator, int x, int y, int z) {
        this.block.setBlockBoundsBasedOnState(TrapDoorBlockModel.renderBlocks.blockAccess, x, y, z);
        int metadata = TrapDoorBlockModel.renderBlocks.blockAccess.getBlockMetadata(x, y, z);
        boolean isUp = TrapDoorBlock.isTrapdoorOpen(metadata);
        if (isUp) {
            switch (metadata & 3) {
                case 0: {
                    TrapDoorBlockModel.renderBlocks.uvRotateNorth = 2;
                    TrapDoorBlockModel.renderBlocks.uvRotateSouth = 1;
                    break;
                }
                case 1: {
                    TrapDoorBlockModel.renderBlocks.uvRotateTop = 3;
                    TrapDoorBlockModel.renderBlocks.uvRotateBottom = 3;
                    TrapDoorBlockModel.renderBlocks.uvRotateNorth = 1;
                    TrapDoorBlockModel.renderBlocks.uvRotateSouth = 2;
                    break;
                }
                case 2: {
                    TrapDoorBlockModel.renderBlocks.uvRotateTop = 2;
                    TrapDoorBlockModel.renderBlocks.uvRotateBottom = 1;
                    TrapDoorBlockModel.renderBlocks.uvRotateEast = 1;
                    TrapDoorBlockModel.renderBlocks.uvRotateWest = 2;
                    break;
                }
                case 3: {
                    TrapDoorBlockModel.renderBlocks.uvRotateTop = 1;
                    TrapDoorBlockModel.renderBlocks.uvRotateBottom = 2;
                    TrapDoorBlockModel.renderBlocks.uvRotateEast = 2;
                    TrapDoorBlockModel.renderBlocks.uvRotateWest = 1;
                }
            }
        } else if (TrapDoorBlock.isUpperHalf(metadata)) {
            TrapDoorBlockModel.renderBlocks.uvRotateSouth = 3;
            TrapDoorBlockModel.renderBlocks.uvRotateNorth = 3;
            TrapDoorBlockModel.renderBlocks.uvRotateEast = 3;
            TrapDoorBlockModel.renderBlocks.uvRotateWest = 3;
        }
        this.renderStandardBlock(tessellator, this.block, x, y, z);
        this.resetRenderBlocks();
        return true;
    }

    @Override
    public void renderBlockOnInventory(Tessellator tessellator, int metadata, float brightness, float alpha, @Nullable Integer lightmapCoordinate) {
        GL11.glTranslatef(0.0f, 0.25f, 0.0f);
        super.renderBlockOnInventory(tessellator, metadata, brightness, alpha, lightmapCoordinate);
    }

    @Override
    public IconCoordinate getBlockTextureFromSideAndMetadata(Side side, int data) {
        int orientation = data & 3;
        if (TrapDoorBlock.isTrapdoorOpen(data)) {
            int index = Sides.orientationLookUpTrapdoorOpen[6 * orientation + side.getId()];
            return this.atlasIndices[index];
        }
        if (side.getAxis() == Axis.Y) {
            return this.atlasIndices[1];
        }
        return this.atlasIndices[3];
    }
}

