/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.blockentity;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.render.EntityRenderDispatcher;
import net.minecraft.client.render.blockentity.BlockEntityRenderer;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.block.entity.MobSpawnerBlockEntity;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityDispatcher;
import net.minecraft.core.world.World;
import org.lwjgl.opengl.GL11;

public class MobSpawnerBlockEntityRenderer
extends BlockEntityRenderer<MobSpawnerBlockEntity> {
    private final Map<String, Entity> entityHashMap = new HashMap<String, Entity>();

    @Override
    public void onWorldChanged(World world) {
        this.entityHashMap.clear();
    }

    @Override
    public void doRender(Tessellator tessellator, MobSpawnerBlockEntity mobSpawner, double x, double y, double z, float partialTick) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x + 0.5f, (float)y, (float)z + 0.5f);
        Entity entity = this.entityHashMap.get(mobSpawner.getMobId());
        if (entity == null) {
            entity = EntityDispatcher.createEntityInWorld(mobSpawner.getMobId(), null);
            this.entityHashMap.put(mobSpawner.getMobId(), entity);
        }
        if (entity != null) {
            entity.setWorld(mobSpawner.worldObj);
            float f1 = 0.4375f;
            GL11.glTranslatef(0.0f, 0.4f, 0.0f);
            GL11.glRotatef((float)(mobSpawner.yaw2 + (mobSpawner.yaw - mobSpawner.yaw2) * (double)partialTick) * 10.0f, 0.0f, 1.0f, 0.0f);
            GL11.glRotatef(-30.0f, 1.0f, 0.0f, 0.0f);
            GL11.glTranslatef(0.0f, -0.4f, 0.0f);
            GL11.glScalef(f1, f1, f1);
            entity.moveTo(mobSpawner.x, mobSpawner.y, mobSpawner.z, 0.0f, 0.0f);
            EntityRenderDispatcher.instance.renderEntityWithPosYaw(tessellator, entity, 0.0, 0.0, 0.0, 0.0f, partialTick);
        }
        GL11.glPopMatrix();
    }
}

