/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.blockentity;

import net.minecraft.client.Minecraft;
import net.minecraft.client.render.Font;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.blockentity.BlockEntityRenderer;
import net.minecraft.client.render.model.SignModel;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.client.util.helper.Colors;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.SignBlockEntity;
import net.minecraft.core.enums.EnumSignPicture;
import net.minecraft.core.util.helper.MathHelper;
import org.lwjgl.opengl.GL11;

public class SignBlockEntityRenderer
extends BlockEntityRenderer<SignBlockEntity> {
    private final Minecraft mc = Minecraft.getMinecraft(this);
    private final SignModel signModel = new SignModel();

    public void renderTileEntitySignAt(SignBlockEntity tileEntity, double d, double d1, double d2, float f) {
        Block block = tileEntity.getBlock();
        GL11.glPushMatrix();
        float scale = 0.6666667f;
        if (block == Blocks.SIGN_POST_PLANKS_OAK) {
            GL11.glTranslatef((float)d + 0.5f, (float)d1 + 0.75f * scale, (float)d2 + 0.5f);
            float f2 = (float)(tileEntity.getBlockMeta() * 360) / 16.0f;
            GL11.glRotatef(-f2, 0.0f, 1.0f, 0.0f);
            this.signModel.signStick.visible = true;
        } else {
            int i = tileEntity.getBlockMeta();
            float f3 = 0.0f;
            if (i == 2) {
                f3 = 180.0f;
            }
            if (i == 4) {
                f3 = 90.0f;
            }
            if (i == 5) {
                f3 = -90.0f;
            }
            GL11.glTranslatef((float)d + 0.5f, (float)d1 + 0.75f * scale, (float)d2 + 0.5f);
            GL11.glRotatef(-f3, 0.0f, 1.0f, 0.0f);
            GL11.glTranslatef(0.0f, -0.3125f, -0.4375f);
            this.signModel.signStick.visible = false;
        }
        this.loadTexture("/assets/minecraft/textures/entity/sign.png");
        GL11.glPushMatrix();
        GL11.glScalef(scale, -scale, -scale);
        this.signModel.render();
        GL11.glPopMatrix();
        Font font = this.getFont();
        GL11.glPushMatrix();
        float f4 = 0.01566f * scale;
        GL11.glTranslatef(0.0f, 0.5f * scale, 0.065f * scale);
        GL11.glScalef(f4, -f4, f4);
        GL11.glNormal3f(0.0f, 0.0f, -1.0f * f4);
        GL11.glDepthMask(false);
        EnumSignPicture picture = tileEntity.getPicture();
        this.drawTexturedModalRect(-48, -24, 48, 24, TextureRegistry.getTexture(picture.getTextureKey()));
        GL11.glPopMatrix();
        float lightLevel = this.mc.theWorld.getLightBrightness(tileEntity.x, tileEntity.y, tileEntity.z);
        float lightOffset = 0.0f;
        if (tileEntity.isGlowing()) {
            lightLevel = 1.0f;
            lightOffset = 96.0f;
            GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            if (LightmapHelper.isLightmapEnabled()) {
                LightmapHelper.setLightmapCoord(LightmapHelper.getLightmapCoord(15, 15));
            }
        }
        GL11.glPushMatrix();
        f4 = 0.01666667f * scale;
        GL11.glTranslatef(0.0f, 0.5f * scale, 0.065f * scale);
        GL11.glScalef(f4, -f4, f4);
        GL11.glNormal3f(0.0f, 0.0f, -1.0f * f4);
        GL11.glDepthMask(false);
        int color = Colors.allSignColors[tileEntity.getColor().id].getARGB();
        int r = (int)MathHelper.clamp((float)(color >> 16 & 0xFF) * lightLevel + lightOffset, 0.0f, 255.0f);
        int g = (int)MathHelper.clamp((float)(color >> 8 & 0xFF) * lightLevel + lightOffset, 0.0f, 255.0f);
        int b = (int)MathHelper.clamp((float)(color >> 0 & 0xFF) * lightLevel + lightOffset, 0.0f, 255.0f);
        color = r << 16 | g << 8 | b << 0;
        for (int line = 0; line < tileEntity.signText.length; ++line) {
            String text = tileEntity.signText[line];
            if (line == tileEntity.lineBeingEdited) {
                text = "> " + text + " <";
            }
            font.drawString(text, -font.getStringWidth(text) / 2, line * 10 - tileEntity.signText.length * 5, color);
        }
        GL11.glPopMatrix();
        GL11.glDepthMask(true);
        GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        GL11.glPopMatrix();
    }

    @Override
    public void doRender(Tessellator tessellator, SignBlockEntity tileEntity, double x, double y, double z, float partialTick) {
        this.renderTileEntitySignAt(tileEntity, x, y, z, partialTick);
    }

    private void drawTexturedModalRect(int x, int y, int width, int height, IconCoordinate coordinate) {
        coordinate.parentAtlas.bind();
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(x + 0, y + height * 2, 0.0, coordinate.getIconUMin(), coordinate.getIconVMax());
        tessellator.addVertexWithUV(x + width * 2, y + height * 2, 0.0, coordinate.getIconUMax(), coordinate.getIconVMax());
        tessellator.addVertexWithUV(x + width * 2, y + 0, 0.0, coordinate.getIconUMax(), coordinate.getIconVMin());
        tessellator.addVertexWithUV(x + 0, y + 0, 0.0, coordinate.getIconUMin(), coordinate.getIconVMin());
        tessellator.draw();
    }
}

