/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.entity;

import net.minecraft.client.render.entity.MobRenderer;
import net.minecraft.client.render.model.BaseModel;
import net.minecraft.client.render.model.CreeperModel;
import net.minecraft.core.entity.monster.CreeperMob;
import net.minecraft.core.util.helper.MathHelper;
import org.lwjgl.opengl.GL11;

public class CreeperRenderer
extends MobRenderer<CreeperMob> {
    private BaseModel chargedModel = new CreeperModel(2.0f);

    public CreeperRenderer() {
        super(new CreeperModel(), 0.5f);
    }

    @Override
    protected void setupScale(CreeperMob creeper, float partialTick) {
        float g = creeper.getSwelling(partialTick);
        float wobble = 1.0f + MathHelper.sin(g * 100.0f) * g * 0.01f;
        if (g < 0.0f) {
            g = 0.0f;
        }
        if (g > 1.0f) {
            g = 1.0f;
        }
        g *= g;
        g *= g;
        float s = (1.0f + g * 0.4f) * wobble;
        float hs = (1.0f + g * 0.1f) / wobble;
        GL11.glScalef(s, hs, s);
    }

    @Override
    protected int getOverlayColor(CreeperMob creeper, float brightness, float partialTick) {
        float step = creeper.getSwelling(partialTick);
        if ((int)(step * 10.0f) % 2 == 0) {
            return 0;
        }
        int _a = (int)(step * 0.2f * 255.0f);
        if (_a < 0) {
            _a = 0;
        }
        if (_a > 255) {
            _a = 255;
        }
        int r = 255;
        int g = 255;
        int b = 255;
        return _a << 24 | 0xFF0000 | 0xFF00 | 0xFF;
    }

    @Override
    protected boolean prepareArmor(CreeperMob entity, int layer, float partialTick) {
        if (entity.getPowered()) {
            if (layer == 1) {
                float f1 = (float)entity.tickCount + partialTick;
                this.bindTexture("/armor/power.png");
                GL11.glMatrixMode(5890);
                GL11.glLoadIdentity();
                float f2 = f1 * 0.01f;
                float f3 = f1 * 0.01f;
                GL11.glTranslatef(f2, f3, 0.0f);
                this.setArmorModel(this.chargedModel);
                GL11.glMatrixMode(5888);
                GL11.glEnable(3042);
                float brightness = 0.5f;
                GL11.glColor4f(brightness, brightness, brightness, 1.0f);
                GL11.glDisable(2896);
                GL11.glBlendFunc(1, 1);
                return true;
            }
            if (layer == 2) {
                GL11.glMatrixMode(5890);
                GL11.glLoadIdentity();
                GL11.glMatrixMode(5888);
                GL11.glEnable(2896);
                GL11.glDisable(3042);
            }
        }
        return false;
    }
}

