/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.entity;

import net.minecraft.client.render.entity.MobRenderer;
import net.minecraft.client.render.model.GhastModel;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.entity.monster.GhastMob;
import org.lwjgl.opengl.GL11;

public class GhastRenderer
extends MobRenderer<GhastMob> {
    public GhastRenderer() {
        super(new GhastModel(), 0.5f);
    }

    @Override
    public void renderPreview(Tessellator tessellator, GhastMob ghastMob, double x, double y, double z, float yaw, float partialTick) {
        GL11.glPushMatrix();
        GL11.glScalef(0.25f, 0.25f, 0.25f);
        super.renderPreview(tessellator, ghastMob, x, y, z, yaw, partialTick);
        GL11.glPopMatrix();
    }

    @Override
    protected void setupScale(GhastMob ghastMob, float partialTick) {
        float charge = ((float)ghastMob.attackChargeO + (float)(ghastMob.attackCharge - ghastMob.attackChargeO) * partialTick) / 20.0f;
        if (charge < 0.0f) {
            charge = 0.0f;
        }
        charge = 1.0f / (charge * charge * charge * charge * charge * 2.0f + 1.0f);
        float f2 = (8.0f + charge) / 2.0f;
        float f3 = (8.0f + 1.0f / charge) / 2.0f;
        GL11.glScalef(f3, f2, f3);
        GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
    }
}

