/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.entity;

import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.entity.MobRenderer;
import net.minecraft.client.render.model.SpiderModel;
import net.minecraft.core.entity.monster.SpiderMob;
import org.lwjgl.opengl.GL11;

public class SpiderRenderer
extends MobRenderer<SpiderMob> {
    public SpiderRenderer() {
        super(new SpiderModel(0.0f), 1.0f);
        this.setArmorModel(new SpiderModel(0.01f));
    }

    protected boolean setSpiderEyeBrightness(SpiderMob spider, int renderPass, float partialTick) {
        if (renderPass == 0) {
            this.bindTexture("/assets/minecraft/textures/entity/spider/eyes/" + spider.getTextureReference() + ".png");
            float brightness = spider.getBrightness(1.0f);
            if (LightmapHelper.isLightmapEnabled()) {
                LightmapHelper.setLightmapCoord(LightmapHelper.getLightmapCoord(15, 15));
            }
            float f1 = (1.0f - brightness) * 0.5f;
            GL11.glEnable(3042);
            GL11.glDisable(3008);
            GL11.glBlendFunc(770, 771);
            GL11.glColor4f(1.0f, 1.0f, 1.0f, f1);
            return true;
        }
        return false;
    }

    @Override
    protected float getMaxDeathRotation(SpiderMob entity) {
        return 180.0f;
    }

    @Override
    protected boolean prepareArmor(SpiderMob entity, int renderPass, float partialTick) {
        return this.setSpiderEyeBrightness(entity, renderPass, partialTick);
    }
}

