/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.sound;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.sound.NamedSoundRepository;
import net.minecraft.client.sound.SoundEntry;
import net.minecraft.client.sound.SoundEvent;
import net.minecraft.core.data.registry.Registry;
import net.minecraft.core.util.collection.NamespaceID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SoundRepository
extends Registry<NamedSoundRepository> {
    protected static Minecraft mc = null;
    public static SoundRepository SOUNDS = null;
    public Set<String> cachedRepositoryErrors = new HashSet<String>();
    public Set<NamespaceID> cachedEntryErrors = new HashSet<NamespaceID>();

    public SoundRepository() {
        this.registerNamespace("minecraft");
    }

    public void registerNamespace(@NotNull String namespace) {
        this.register(namespace, new NamedSoundRepository(namespace));
    }

    @Nullable
    public SoundEvent getSoundEvent(@Nullable String key) {
        if (key == null) {
            return null;
        }
        return this.getSoundEvent(this.makeNamespaceFromKey(key));
    }

    @Nullable
    public SoundEvent getSoundEvent(@Nullable NamespaceID namespaceID) {
        if (namespaceID == null) {
            return null;
        }
        NamedSoundRepository soundRepository = (NamedSoundRepository)this.getItem(namespaceID.namespace);
        if (soundRepository == null) {
            if (!this.cachedRepositoryErrors.contains(namespaceID.namespace)) {
                System.err.println("Could not find sound repository under namespace '" + namespaceID.namespace + "'!");
                this.cachedRepositoryErrors.add(namespaceID.namespace);
            }
            return null;
        }
        return (SoundEvent)soundRepository.getItem(namespaceID.value);
    }

    @Nullable
    public SoundEntry getSoundEntry(@Nullable String key) {
        if (key == null) {
            return null;
        }
        return this.getSoundEntry(this.makeNamespaceFromKey(key));
    }

    @Nullable
    public SoundEntry getSoundEntry(@Nullable NamespaceID namespaceID) {
        if (namespaceID == null) {
            return null;
        }
        SoundEvent event = this.getSoundEvent(namespaceID);
        if (event == null) {
            if (!this.cachedEntryErrors.contains(namespaceID)) {
                System.err.println("Could not find sound event in namespace '" + namespaceID.namespace + "' matching key '" + namespaceID.value + "'!");
                this.cachedEntryErrors.add(namespaceID);
            }
            return null;
        }
        return event.getRandomEntry();
    }

    @Nullable
    public SoundEvent getRandomSoundFromCategory(@NotNull String category) {
        ArrayList eventList = new ArrayList();
        for (NamedSoundRepository nsr : this) {
            nsr.iterator().forEachRemaining(soundEvent -> {
                if (soundEvent.getEventID().startsWith(category)) {
                    eventList.add(soundEvent);
                }
            });
        }
        if (eventList.isEmpty()) {
            return null;
        }
        return (SoundEvent)eventList.get(new Random().nextInt(eventList.size()));
    }

    public List<SoundEvent> getAllEvents() {
        ArrayList<SoundEvent> eventList = new ArrayList<SoundEvent>();
        for (NamedSoundRepository nsr : this) {
            nsr.iterator().forEachRemaining(eventList::add);
        }
        return eventList;
    }

    private NamespaceID makeNamespaceFromKey(@NotNull String key) {
        String value;
        String namespace;
        if (!key.contains(":")) {
            namespace = "minecraft";
            value = key;
        } else {
            String[] split = key.split(":");
            if (split.length != 2) {
                throw new IllegalArgumentException("Invalid key '" + key + "', there can only be 1 namespace value delimiter of ':'!");
            }
            namespace = split[0];
            value = split[1];
            if (namespace.isEmpty()) {
                throw new IllegalArgumentException("Invalid key '" + key + "', Namespace must not be empty!");
            }
        }
        return new NamespaceID(namespace, value);
    }

    public static void initialize(Minecraft mc) {
        SoundRepository.mc = mc;
        if (SOUNDS == null) {
            SoundRepository.reload();
        }
    }

    public static void reload() {
        SOUNDS = new SoundRepository();
    }
}

