/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.util.debug;

import net.minecraft.client.Minecraft;
import net.minecraft.client.render.Font;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.util.debug.Debug;
import net.minecraft.core.util.helper.MathHelper;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;

public class DebugRender {
    private static Debug.Profiler selectedProfiler = Debug.baseProfiler;
    private static final long[] frametimes = new long[512];
    private static final long[] baseframetimes = new long[512];
    private static int pos = 0;
    private static int scale = 200000;
    private static int selection = 0;

    public static void onDebugMenuOpened() {
    }

    public static boolean keyPressed(int key) {
        if (key == Keyboard.KEY_LEFT) {
            if (DebugRender.selectedProfiler.parent != null) {
                Debug.Profiler prev = selectedProfiler;
                DebugRender.set(DebugRender.selectedProfiler.parent);
                selection = DebugRender.selectedProfiler.allProfilers.indexOf(prev);
            }
            return true;
        }
        if (key == Keyboard.KEY_UP) {
            selection = selection == 0 ? DebugRender.selectedProfiler.allProfilers.size() - 1 : --selection;
            return true;
        }
        if (key == Keyboard.KEY_DOWN) {
            selection = selection >= DebugRender.selectedProfiler.allProfilers.size() - 1 ? 0 : ++selection;
            return true;
        }
        if (key == Keyboard.KEY_RIGHT) {
            if (selection >= 0 && selection < DebugRender.selectedProfiler.allProfilers.size()) {
                DebugRender.set(DebugRender.selectedProfiler.allProfilers.get(selection));
                selection = 0;
            }
            return true;
        }
        return false;
    }

    private static void set(Debug.Profiler profiler) {
        selectedProfiler = profiler;
        DebugRender.resetFrametimes();
    }

    public static void render(Font font) {
        DebugRender.frametimes[DebugRender.pos] = DebugRender.selectedProfiler.time;
        DebugRender.baseframetimes[DebugRender.pos] = Debug.baseProfiler.time;
        if (++pos >= frametimes.length) {
            pos = 0;
        }
        int w = Display.getWidth();
        int h = Display.getHeight();
        GL11.glMatrixMode(5889);
        GL11.glLoadIdentity();
        GL11.glOrtho(0.0, w, h, 0.0, -1.0, 1.0);
        GL11.glMatrixMode(5888);
        GL11.glLoadIdentity();
        GL11.glDisable(2929);
        GL11.glEnable(3008);
        GL11.glDisable(3553);
        GL11.glDisable(2884);
        GL11.glDisable(2896);
        GL11.glEnable(3042);
        GL11.glBlendFunc(770, 771);
        Tessellator tessellator = Tessellator.instance;
        int x = w - frametimes.length;
        int y = h;
        if (selectedProfiler != Debug.baseProfiler) {
            if (w > frametimes.length + baseframetimes.length) {
                DebugRender.drawFrameTimes(tessellator, x, y, baseframetimes);
            }
            DebugRender.drawFrameTimes(tessellator, 0, y, frametimes);
        } else {
            DebugRender.drawFrameTimes(tessellator, 0, y, baseframetimes);
        }
        GL11.glDisable(3042);
        GL11.glEnable(3553);
        GL11.glColor4d(1.0, 1.0, 1.0, 1.0);
        int lineHeight = 8;
        int x1 = frametimes.length;
        int y1 = h - (DebugRender.selectedProfiler.allProfilers.size() + 1) * lineHeight * 2;
        GL11.glTranslated(x1, y1, 0.0);
        x1 = 0;
        y1 = 0;
        GL11.glScaled(2.0, 2.0, 2.0);
        int fps = Debug.getFps();
        if (fps >= 0) {
            font.drawString("fps: " + fps, x1, y1 - 2 * lineHeight, -1);
        }
        font.drawString("avg: " + (double)DebugRender.getAvgTime(frametimes) / 1000.0 + " ms", x1, y1 - lineHeight, -1);
        font.drawString(DebugRender.selectedProfiler.name + ": ", x1, y1, -1);
        for (int i = 0; i < DebugRender.selectedProfiler.allProfilers.size(); ++i) {
            Debug.Profiler profiler = DebugRender.selectedProfiler.allProfilers.get(i);
            int color = -1;
            if (i == selection) {
                color = -16711681;
            }
            font.drawString(i + ": " + profiler.name, x1, y1 + (i + 1) * lineHeight, color);
        }
        GL11.glEnable(3008);
    }

    private static long getAvgTime(long[] frametimes) {
        long avg = 0L;
        int count = 0;
        for (int i = 0; i < frametimes.length; ++i) {
            long time = frametimes[i];
            if (time <= 0L) continue;
            avg += frametimes[i] / 1000L;
            ++count;
        }
        if (count == 0) {
            return 1L;
        }
        return avg /= (long)count;
    }

    private static void drawFrameTimes(Tessellator tessellator, int x, int y, long[] frametimes) {
        int h1 = 16666666 / scale;
        int h2 = 33333333 / scale;
        tessellator.startDrawingQuads();
        tessellator.setColorRGBA(0, 0, 0, 127);
        DebugRender.drawRectangle(tessellator, x, y - h2, frametimes.length, h2);
        DebugRender.drawRectangle(tessellator, x, y - h1, frametimes.length, h1);
        tessellator.setColorOpaque_I(0xFFFFFF);
        for (int i = 0; i < frametimes.length; ++i) {
            float brightness = (float)(i - pos & frametimes.length - 1) / (float)frametimes.length;
            brightness *= brightness;
            int b = MathHelper.clamp((int)(brightness * 255.0f), 0, 255);
            tessellator.setColorOpaque_I(b << 16 | b << 8 | b);
            int time = (int)(frametimes[i] / (long)scale);
            DebugRender.drawRectangle(tessellator, x + i, y - time, 1, time);
        }
        int tickLagHeight = (int)(5.0E7 / (double)scale);
        tessellator.setColorOpaque_I(0xFF0000);
        DebugRender.drawRectangle(tessellator, x, y - tickLagHeight, frametimes.length, 1);
        Minecraft mc = Minecraft.getMinecraft(Minecraft.class);
        if ((Integer)mc.gameSettings.customFpsLimit.value > 0 || ((Boolean)mc.gameSettings.enableVsync.value).booleanValue()) {
            tessellator.setColorOpaque_I(65280);
            int fps = 0;
            fps = (Boolean)mc.gameSettings.enableVsync.value != false ? mc.gameWindow.getFrequency() : ((Integer)mc.gameSettings.customFpsLimit.value).intValue();
            int frameLagHeight = (int)(1000.0 / (double)fps * 1000.0 * 1000.0 / (double)scale);
            DebugRender.drawRectangle(tessellator, x, y - frameLagHeight, frametimes.length, 1);
        }
        tessellator.draw();
    }

    private static void drawRectangle(Tessellator tessellator, int x, int y, int w, int h) {
        tessellator.addVertex(x, y, 0.0);
        tessellator.addVertex(x + w, y, 0.0);
        tessellator.addVertex(x + w, y + h, 0.0);
        tessellator.addVertex(x, y + h, 0.0);
    }

    private static void resetFrametimes() {
        for (int i = 0; i < frametimes.length; ++i) {
            DebugRender.frametimes[i] = 0L;
        }
    }

    public static void dontRender() {
    }
}

