/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.world;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.net.handler.ClientPacketHandler;
import net.minecraft.client.world.chunk.provider.ChunkProviderClient;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.net.packet.DisconnectPacket;
import net.minecraft.core.util.collection.IntHashMap;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.ChunkCoordinates;
import net.minecraft.core.world.chunk.provider.IChunkProvider;
import net.minecraft.core.world.save.LevelStorage;
import net.minecraft.core.world.save.SaveHandlerClientMP;

public class WorldClient
extends World {
    private final Minecraft mc;
    private final LinkedList<WorldBlockPositionType> positionTypesList;
    private final ClientPacketHandler sendQueue;
    private ChunkProviderClient chunkCache;
    private final IntHashMap<Entity> entitiesById;
    private final Set<Entity> forced;
    private final Set<Entity> reEntries;

    public WorldClient(Minecraft minecraft, ClientPacketHandler netclienthandler, long seed, int dimensionId, int worldTypeId) {
        super((LevelStorage)new SaveHandlerClientMP(), "MpServer", Dimension.getDimensionList().get(dimensionId), Registries.WORLD_TYPES.getItemByNumericId(worldTypeId), seed);
        this.mc = minecraft;
        this.positionTypesList = new LinkedList();
        this.entitiesById = new IntHashMap();
        this.forced = new HashSet<Entity>();
        this.reEntries = new HashSet<Entity>();
        this.sendQueue = netclienthandler;
        this.setSpawnPoint(new ChunkCoordinates(8, 64, 8));
        this.savedDataStorage = netclienthandler.savedDataStorage;
    }

    @Override
    public void tick() {
        for (int k = 0; k < 10 && !this.reEntries.isEmpty(); ++k) {
            Entity entity = this.reEntries.iterator().next();
            if (this.loadedEntityList.contains(entity)) continue;
            this.entityJoinedWorld(entity);
        }
        this.processPackets();
        for (int l = 0; l < this.positionTypesList.size(); ++l) {
            WorldBlockPositionType worldblockpositiontype = this.positionTypesList.get(l);
            if (--worldblockpositiontype.delayTicks != 0) continue;
            super.setBlockAndMetadata(worldblockpositiontype.x, worldblockpositiontype.y, worldblockpositiontype.z, worldblockpositiontype.blockId, worldblockpositiontype.metadata);
            super.markBlockNeedsUpdate(worldblockpositiontype.x, worldblockpositiontype.y, worldblockpositiontype.z);
            this.positionTypesList.remove(l--);
        }
        this.updateSeasonAndLight();
        if (this.rainbowTicks > 0) {
            --this.rainbowTicks;
        }
    }

    public void processPackets() {
        this.sendQueue.tick();
    }

    public void removePositionTypesInBounds(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        for (int i = 0; i < this.positionTypesList.size(); ++i) {
            WorldBlockPositionType worldblockpositiontype = this.positionTypesList.get(i);
            if (worldblockpositiontype.x < minX || worldblockpositiontype.y < minY || worldblockpositiontype.z < minZ || worldblockpositiontype.x > maxX || worldblockpositiontype.y > maxY || worldblockpositiontype.z > maxZ) continue;
            this.positionTypesList.remove(i--);
        }
    }

    @Override
    protected IChunkProvider createChunkProvider() {
        this.chunkCache = new ChunkProviderClient(this);
        return this.chunkCache;
    }

    @Override
    public void getRespawnLocation() {
        this.setSpawnPoint(new ChunkCoordinates(8, 64, 8));
    }

    @Override
    protected void updateBlocksAndPlayCaveSounds() {
    }

    @Override
    public void scheduleBlockUpdate(int x, int y, int z, int id, int delay) {
    }

    @Override
    public boolean tickUpdates(boolean all) {
        return false;
    }

    public void doPreChunk(int chunkX, int chunkZ, boolean playerAdded) {
        if (playerAdded) {
            this.chunkCache.prepareChunk(chunkX, chunkZ);
        } else {
            this.chunkCache.dropChunk(chunkX, chunkZ);
        }
        if (!playerAdded) {
            this.markBlocksDirty(chunkX * 16, 0, chunkZ * 16, chunkX * 16 + 15, this.getHeightBlocks(), chunkZ * 16 + 15);
        }
    }

    @Override
    public boolean entityJoinedWorld(Entity entity) {
        boolean flag = super.entityJoinedWorld(entity);
        this.forced.add(entity);
        if (!flag) {
            this.reEntries.add(entity);
        }
        return flag;
    }

    @Override
    public void setEntityDead(Entity entity) {
        super.setEntityDead(entity);
        this.forced.remove(entity);
    }

    @Override
    protected void obtainEntitySkin(Entity entity) {
        super.obtainEntitySkin(entity);
        this.reEntries.remove(entity);
    }

    @Override
    protected void releaseEntitySkin(Entity entity) {
        super.releaseEntitySkin(entity);
        if (this.forced.contains(entity)) {
            this.reEntries.add(entity);
        }
    }

    public void addEntityToWorld(int i, Entity entity) {
        Entity entity1 = this.getEntityFromId(i);
        if (entity1 != null) {
            this.setEntityDead(entity1);
        }
        this.forced.add(entity);
        entity.id = i;
        if (!this.entityJoinedWorld(entity)) {
            this.reEntries.add(entity);
        }
        this.entitiesById.put(i, entity);
    }

    public Entity getEntityFromId(int i) {
        return this.entitiesById.get(i);
    }

    public Entity removeEntityFromWorld(int i) {
        Entity entity = this.entitiesById.remove(i);
        if (entity != null) {
            this.forced.remove(entity);
            this.setEntityDead(entity);
        }
        return entity;
    }

    @Override
    public boolean setBlockMetadata(int x, int y, int z, int meta) {
        int blockID = this.getBlockId(x, y, z);
        int currentMeta = this.getBlockMetadata(x, y, z);
        if (super.setBlockMetadata(x, y, z, meta)) {
            this.positionTypesList.add(new WorldBlockPositionType(x, y, z, blockID, currentMeta));
            return true;
        }
        return false;
    }

    @Override
    public boolean setBlockAndMetadata(int x, int y, int z, int id, int meta) {
        int blockId = this.getBlockId(x, y, z);
        int blockMeta = this.getBlockMetadata(x, y, z);
        if (super.setBlockAndMetadata(x, y, z, id, meta)) {
            this.positionTypesList.add(new WorldBlockPositionType(x, y, z, blockId, blockMeta));
            return true;
        }
        return false;
    }

    @Override
    public boolean setBlock(int x, int y, int z, int id) {
        int blockId = this.getBlockId(x, y, z);
        int meta = this.getBlockMetadata(x, y, z);
        if (super.setBlock(x, y, z, id)) {
            this.positionTypesList.add(new WorldBlockPositionType(x, y, z, blockId, meta));
            return true;
        }
        return false;
    }

    public boolean blockChange(int x, int y, int z, int id, int meta) {
        this.removePositionTypesInBounds(x, y, z, x, y, z);
        if (super.setBlockAndMetadata(x, y, z, id, meta)) {
            this.notifyBlockChange(x, y, z, id);
            return true;
        }
        return false;
    }

    @Override
    public void sendQuittingDisconnectingPacket() {
        this.sendQueue.sendFinalPacket(new DisconnectPacket("Quitting"));
    }

    @Override
    public void sendGlobalMessage(String message) {
    }

    static class WorldBlockPositionType {
        int x;
        int y;
        int z;
        int delayTicks;
        int blockId;
        int metadata;

        public WorldBlockPositionType(int x, int y, int z, int blockId, int metadata) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.delayTicks = 80;
            this.blockId = blockId;
            this.metadata = metadata;
        }
    }
}

