/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.BlockEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.vehicle.BoatEntity;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;

public class AlgaeBlock
extends Block {
    protected AlgaeBlock(String key, String namespaceId, int id, Material material) {
        super(key, namespaceId, id, material);
        this.setBlockBounds(0.0, -0.125, 0.0, 1.0, 0.00625f, 1.0);
    }

    @Override
    public void onEntityCollidedWithBlock(World world, int x, int y, int z, Entity entity) {
        if (entity instanceof BoatEntity) {
            int data = world.getBlockMetadata(x, y, z);
            world.playBlockEvent(null, 2001, x, y, z, this.id);
            world.setBlockWithNotify(x, y, z, 0);
            this.onBlockRemoved(world, x, y, z, data);
        }
    }

    @Override
    public boolean canPlaceBlockAt(World world, int x, int y, int z) {
        int blockId = world.getBlockId(x, y, z);
        return blockId == 0 && Block.hasTag(world.getBlockId(x, y - 1, z), BlockTags.IS_WATER) && world.getBlockMetadata(x, y - 1, z) == 0;
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        if (!Block.hasTag(world.getBlockId(x, y - 1, z), BlockTags.IS_WATER) || world.getBlockMetadata(x, y - 1, z) != 0) {
            world.setBlock(x, y, z, 0);
        }
    }

    @Override
    public AABB getCollisionBoundingBoxFromPool(WorldSource world, int x, int y, int z) {
        return null;
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int meta, BlockEntity blockEntity) {
        switch (dropCause) {
            case SILK_TOUCH: 
            case PICK_BLOCK: {
                return new ItemStack[]{new ItemStack(this)};
            }
        }
        return null;
    }
}

