/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.function.Supplier;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.item.block.LayerBlockItem;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.WorldSource;

public abstract class BaseLayerBlock
extends Block {
    private Supplier<Integer> idSupplier = () -> -1;

    public BaseLayerBlock(String key, String namespaceId, int id, Material material) {
        super(key, namespaceId, id, material);
        this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);
        this.setBlockItem(() -> new LayerBlockItem(this));
    }

    public BaseLayerBlock setFullBlockID(Supplier<Integer> idSupplier) {
        this.idSupplier = idSupplier;
        return this;
    }

    @Override
    public AABB getCollisionBoundingBoxFromPool(WorldSource world, int x, int y, int z) {
        int l = world.getBlockMetadata(x, y, z) & 7;
        float f = (float)(2 * (1 + l)) / 16.0f;
        return AABB.getTemporaryBB((double)x + this.minX, (double)y + this.minY, (double)z + this.minZ, (double)x + this.maxX, (float)y + f, (double)z + this.maxZ);
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    public void setBlockBoundsBasedOnState(WorldSource world, int x, int y, int z) {
        int l = world.getBlockMetadata(x, y, z) & 7;
        float f = (float)(2 * (1 + l)) / 16.0f;
        this.setBlockBounds(0.0, 0.0, 0.0, 1.0, f, 1.0);
    }

    public int getFullBlockID() {
        return this.idSupplier.get();
    }
}

