/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.BlockEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.world.World;

public abstract class EntityBlock
extends Block {
    public EntityBlock(String key, String namespaceId, int id, Material material) {
        super(key, namespaceId, id, material);
        EntityBlock.isEntityTile[id] = true;
    }

    @Override
    public void onBlockPlacedByWorld(World world, int x, int y, int z) {
        super.onBlockPlacedByWorld(world, x, y, z);
        world.setBlockTileEntity(x, y, z, this.getNewBlockEntity());
    }

    @Override
    public void onBlockRemoved(World world, int x, int y, int z, int data) {
        BlockEntity blockEntity;
        super.onBlockRemoved(world, x, y, z, data);
        if (!world.isClientSide && (blockEntity = world.getBlockEntity(x, y, z)) != null) {
            blockEntity.dropContents(world, x, y, z);
        }
        world.removeBlockTileEntity(x, y, z);
    }

    protected abstract BlockEntity getNewBlockEntity();
}

