/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.MossBlock;
import net.minecraft.core.block.PortalBlock;
import net.minecraft.core.block.TNTBlock;
import net.minecraft.core.block.entity.BlockEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;

public class FireBlock
extends Block {
    public static final int FLAME_INSTANT = 60;
    public static final int FLAME_EASY = 30;
    public static final int FLAME_MEDIUM = 15;
    public static final int FLAME_HARD = 5;
    public static final int BURN_INSTANT = 100;
    public static final int BURN_EASY = 60;
    public static final int BURN_MEDIUM = 20;
    public static final int BURN_HARD = 5;
    public static final int BURN_NEVER = 0;
    private static final int[] flameChance = new int[Block.blocksList.length];
    private static final int[] burnChance = new int[Block.blocksList.length];

    public FireBlock(String key, String namespaceId, int id) {
        super(key, namespaceId, id, Material.fire);
        this.setTicking(true);
        this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int meta, BlockEntity blockEntity) {
        return null;
    }

    @Override
    public void initializeBlock() {
        FireBlock.setFlammable(Blocks.PLANKS_OAK.id, 5, 20);
        FireBlock.setFlammable(Blocks.PLANKS_OAK_PAINTED.id, 5, 20);
        FireBlock.setFlammable(Blocks.FENCE_PLANKS_OAK.id, 5, 20);
        FireBlock.setFlammable(Blocks.FENCE_PLANKS_OAK_PAINTED.id, 5, 20);
        FireBlock.setFlammable(Blocks.SLAB_PLANKS_OAK.id, 5, 20);
        FireBlock.setFlammable(Blocks.SLAB_PLANKS_PAINTED.id, 5, 20);
        FireBlock.setFlammable(Blocks.STAIRS_PLANKS_OAK.id, 5, 20);
        FireBlock.setFlammable(Blocks.LOG_OAK.id, 5, 5);
        FireBlock.setFlammable(Blocks.LOG_PINE.id, 5, 5);
        FireBlock.setFlammable(Blocks.LOG_BIRCH.id, 5, 5);
        FireBlock.setFlammable(Blocks.LOG_CHERRY.id, 5, 5);
        FireBlock.setFlammable(Blocks.LOG_OAK_MOSSY.id, 5, 5);
        FireBlock.setFlammable(Blocks.LOG_EUCALYPTUS.id, 5, 5);
        FireBlock.setFlammable(Blocks.LEAVES_OAK.id, 30, 60);
        FireBlock.setFlammable(Blocks.LEAVES_PINE.id, 30, 60);
        FireBlock.setFlammable(Blocks.LEAVES_BIRCH.id, 30, 60);
        FireBlock.setFlammable(Blocks.LEAVES_CHERRY.id, 30, 60);
        FireBlock.setFlammable(Blocks.LEAVES_CHERRY_FLOWERING.id, 30, 60);
        FireBlock.setFlammable(Blocks.LEAVES_OAK_RETRO.id, 30, 60);
        FireBlock.setFlammable(Blocks.LEAVES_SHRUB.id, 30, 60);
        FireBlock.setFlammable(Blocks.LEAVES_EUCALYPTUS.id, 30, 60);
        FireBlock.setFlammable(Blocks.LEAVES_CACAO.id, 30, 60);
        FireBlock.setFlammable(Blocks.BOOKSHELF_PLANKS_OAK.id, 30, 20);
        FireBlock.setFlammable(Blocks.TNT.id, 15, 100);
        FireBlock.setFlammable(Blocks.WOOL.id, 30, 60);
        FireBlock.setFlammable(Blocks.MOSS_STONE.id, 100, 30);
        FireBlock.setFlammable(Blocks.MOSS_BASALT.id, 100, 30);
        FireBlock.setFlammable(Blocks.MOSS_LIMESTONE.id, 100, 30);
        FireBlock.setFlammable(Blocks.MOSS_GRANITE.id, 100, 30);
    }

    public static void setFlammable(int id, int flameChance, int burnChance) {
        FireBlock.flameChance[id] = flameChance;
        FireBlock.burnChance[id] = burnChance;
    }

    @Override
    public AABB getCollisionBoundingBoxFromPool(WorldSource world, int x, int y, int z) {
        return null;
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    public void onBlockRemoved(World world, int x, int y, int z, int data) {
        for (int i = 0; i < 8; ++i) {
            world.spawnParticle("largesmoke", (double)x + Math.random(), (double)y + 0.5, (double)z + Math.random(), 0.0, 0.0, 0.0, 0);
        }
    }

    @Override
    public int tickDelay() {
        return 40;
    }

    public void setBurnResult(World world, int x, int y, int z) {
        world.setBlockWithNotify(x, y, z, this.getBurnResultId(world, x, y, z));
    }

    @Override
    public void updateTick(World world, int x, int y, int z, Random rand) {
        boolean infiniBurn;
        Block blockUnder = world.getBlock(x, y - 1, z);
        boolean bl = infiniBurn = blockUnder != null && blockUnder.hasTag(BlockTags.INFINITE_BURN);
        if (!this.isValidFireLocation(world, x, y, z)) {
            this.setBurnResult(world, x, y, z);
        }
        if (!infiniBurn && world.getCurrentWeather() != null && world.getCurrentWeather().isPrecipitation && (world.canBlockBeRainedOn(x, y, z) || world.canBlockBeRainedOn(x - 1, y, z) || world.canBlockBeRainedOn(x + 1, y, z) || world.canBlockBeRainedOn(x, y, z - 1) || world.canBlockBeRainedOn(x, y, z + 1))) {
            this.setBurnResult(world, x, y, z);
            return;
        }
        int meta = world.getBlockMetadata(x, y, z);
        if (meta < 15) {
            world.setBlockMetadata(x, y, z, meta + rand.nextInt(3) / 2);
        }
        world.scheduleBlockUpdate(x, y, z, this.id, this.tickDelay());
        if (!infiniBurn && !this.canNeighborCatchFire(world, x, y, z)) {
            if (!world.isBlockNormalCube(x, y - 1, z) || meta > 3) {
                this.setBurnResult(world, x, y, z);
            }
            return;
        }
        if (!infiniBurn && !FireBlock.canBurn(world, x, y - 1, z) && meta == 15 && rand.nextInt(4) == 0) {
            this.setBurnResult(world, x, y, z);
            return;
        }
        this.checkBurn(world, x + 1, y, z, 300, rand, meta);
        this.checkBurn(world, x - 1, y, z, 300, rand, meta);
        this.checkBurn(world, x, y - 1, z, 250, rand, meta);
        this.checkBurn(world, x, y + 1, z, 250, rand, meta);
        this.checkBurn(world, x, y, z - 1, 300, rand, meta);
        this.checkBurn(world, x, y, z + 1, 300, rand, meta);
        for (int x1 = x - 1; x1 <= x + 1; ++x1) {
            for (int z1 = z - 1; z1 <= z + 1; ++z1) {
                for (int y1 = y - 1; y1 <= y + 4; ++y1) {
                    int c;
                    int b;
                    if (x1 == x && y1 == y && z1 == z) continue;
                    int a = 100;
                    if (y1 > y + 1) {
                        a += (y1 - (y + 1)) * 100;
                    }
                    if ((b = this.getFireChance(world, x1, y1, z1)) <= 0 || (c = (b + 40) / (meta + 30)) <= 0 || rand.nextInt(a) > c || world.getCurrentWeather() != null && world.getCurrentWeather().isPrecipitation && world.canBlockBeRainedOn(x1, y1, z1) || world.canBlockBeRainedOn(x1 - 1, y1, z) || world.canBlockBeRainedOn(x1 + 1, y1, z1) || world.canBlockBeRainedOn(x1, y1, z1 - 1) || world.canBlockBeRainedOn(x1, y1, z1 + 1) || this.getBurnResultId(world, x1, y1, z1) != 0) continue;
                    world.setBlockAndMetadataWithNotify(x1, y1, z1, this.id, Math.min(meta + rand.nextInt(5) / 4, 15));
                }
            }
        }
    }

    private void checkBurn(World world, int x, int y, int z, int chance, Random random, int meta) {
        if (random.nextInt(chance) < burnChance[world.getBlockId(x, y, z)]) {
            boolean isTNT;
            boolean bl = isTNT = world.getBlockId(x, y, z) == Blocks.TNT.id;
            if (random.nextInt(meta + 10) < 5 && !world.canBlockBeRainedOn(x, y, z)) {
                if (this.getBurnResultId(world, x, y, z) == 0) {
                    world.setBlockAndMetadataWithNotify(x, y, z, this.id, Math.min(meta + random.nextInt(5) / 4, 15));
                }
            } else {
                this.setBurnResult(world, x, y, z);
            }
            if (isTNT) {
                TNTBlock TNTBlock2 = (TNTBlock)Blocks.TNT;
                TNTBlock2.ignite(world, x, y, z, true);
            }
        }
    }

    private boolean canNeighborCatchFire(World world, int x, int y, int z) {
        if (FireBlock.canBurn(world, x + 1, y, z)) {
            return true;
        }
        if (FireBlock.canBurn(world, x - 1, y, z)) {
            return true;
        }
        if (FireBlock.canBurn(world, x, y - 1, z)) {
            return true;
        }
        if (FireBlock.canBurn(world, x, y + 1, z)) {
            return true;
        }
        if (FireBlock.canBurn(world, x, y, z - 1)) {
            return true;
        }
        return FireBlock.canBurn(world, x, y, z + 1);
    }

    private int getFireChance(World world, int x, int y, int z) {
        int flammability = 0;
        if (!world.isAirBlock(x, y, z)) {
            return 0;
        }
        flammability = FireBlock.getFlammability(world, x + 1, y, z, flammability);
        flammability = FireBlock.getFlammability(world, x - 1, y, z, flammability);
        flammability = FireBlock.getFlammability(world, x, y - 1, z, flammability);
        flammability = FireBlock.getFlammability(world, x, y + 1, z, flammability);
        flammability = FireBlock.getFlammability(world, x, y, z - 1, flammability);
        flammability = FireBlock.getFlammability(world, x, y, z + 1, flammability);
        return flammability;
    }

    public static boolean canBurn(WorldSource worldSource, int x, int y, int z) {
        return flameChance[worldSource.getBlockId(x, y, z)] > 0;
    }

    public static boolean canBurn(int blockId) {
        return flameChance[blockId] > 0;
    }

    public static int getFlammability(World world, int x, int y, int z, int currentFlameChance) {
        int blockFlameChance = flameChance[world.getBlockId(x, y, z)];
        return Math.max(blockFlameChance, currentFlameChance);
    }

    public boolean isValidFireLocation(World world, int x, int y, int z) {
        return world.isBlockNormalCube(x, y - 1, z) || this.canNeighborCatchFire(world, x, y, z);
    }

    @Override
    public boolean canPlaceBlockAt(World world, int x, int y, int z) {
        return this.isValidFireLocation(world, x, y, z);
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        if (!world.isBlockNormalCube(x, y - 1, z) && !this.canNeighborCatchFire(world, x, y, z)) {
            world.setBlockWithNotify(x, y, z, this.getBurnResultId(world, x, y, z));
        }
    }

    protected int getBurnResultId(World world, int x, int y, int z) {
        int id = world.getBlockId(x, y, z);
        Block stoneBlock = MossBlock.getStoneBlock(id);
        if (stoneBlock != null) {
            return stoneBlock.id;
        }
        return 0;
    }

    @Override
    public void onBlockPlacedByWorld(World world, int x, int y, int z) {
        if (world.getBlockId(x, y - 1, z) == Blocks.OBSIDIAN.id && ((PortalBlock)Blocks.PORTAL_NETHER).tryToCreatePortal(world, x, y, z)) {
            return;
        }
        if (!world.isBlockNormalCube(x, y - 1, z) && !this.canNeighborCatchFire(world, x, y, z)) {
            world.setBlockWithNotify(x, y, z, this.getBurnResultId(world, x, y, z));
        } else {
            world.scheduleBlockUpdate(x, y, z, this.id, this.tickDelay());
        }
    }

    public void ignite(World world, int x, int y, int z) {
        boolean hasCreatedFire = false;
        if (!hasCreatedFire) {
            hasCreatedFire = this.tryIgnite(world, x, y + 1, z);
        }
        if (!hasCreatedFire) {
            hasCreatedFire = this.tryIgnite(world, x - 1, y, z);
        }
        if (!hasCreatedFire) {
            hasCreatedFire = this.tryIgnite(world, x + 1, y, z);
        }
        if (!hasCreatedFire) {
            hasCreatedFire = this.tryIgnite(world, x, y, z - 1);
        }
        if (!hasCreatedFire) {
            hasCreatedFire = this.tryIgnite(world, x, y, z + 1);
        }
        if (!hasCreatedFire) {
            hasCreatedFire = this.tryIgnite(world, x, y - 1, z);
        }
        if (!hasCreatedFire) {
            world.setBlock(x, y, z, Blocks.FIRE.id);
        }
    }

    private boolean tryIgnite(World world, int x, int y, int z) {
        int tile = world.getBlockId(x, y, z);
        if (tile == Blocks.FIRE.id) {
            return true;
        }
        if (tile == 0) {
            world.setBlock(x, y, z, Blocks.FIRE.id);
            return true;
        }
        return false;
    }

    @Override
    public void animationTick(World world, int x, int y, int z, Random rand) {
        block12: {
            block11: {
                if (rand.nextInt(24) == 0) {
                    world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f, "fire.fire", 1.0f + rand.nextFloat(), rand.nextFloat() * 0.7f + 0.3f);
                }
                if (!world.isBlockNormalCube(x, y - 1, z) && !FireBlock.canBurn(world, x, y - 1, z)) break block11;
                for (int l = 0; l < 3; ++l) {
                    double f = (double)x + (double)rand.nextFloat();
                    double f6 = (double)y + (double)(rand.nextFloat() * 0.5f) + 0.5;
                    double f12 = (double)z + (double)rand.nextFloat();
                    world.spawnParticle("largesmoke", f, f6, f12, 0.0, 0.0, 0.0, 0);
                }
                break block12;
            }
            if (FireBlock.canBurn(world, x - 1, y, z)) {
                for (int i1 = 0; i1 < 2; ++i1) {
                    double f1 = (double)x + (double)(rand.nextFloat() * 0.1f);
                    double f7 = (double)y + (double)rand.nextFloat();
                    double f13 = (double)z + (double)rand.nextFloat();
                    world.spawnParticle("largesmoke", f1, f7, f13, 0.0, 0.0, 0.0, 0);
                }
            }
            if (FireBlock.canBurn(world, x + 1, y, z)) {
                for (int j1 = 0; j1 < 2; ++j1) {
                    double f2 = (double)(x + 1) - (double)(rand.nextFloat() * 0.1f);
                    double f8 = (double)y + (double)rand.nextFloat();
                    double f14 = (double)z + (double)rand.nextFloat();
                    world.spawnParticle("largesmoke", f2, f8, f14, 0.0, 0.0, 0.0, 0);
                }
            }
            if (FireBlock.canBurn(world, x, y, z - 1)) {
                for (int k1 = 0; k1 < 2; ++k1) {
                    double f3 = (double)x + (double)rand.nextFloat();
                    double f9 = (double)y + (double)rand.nextFloat();
                    double f15 = (double)z + (double)(rand.nextFloat() * 0.1f);
                    world.spawnParticle("largesmoke", f3, f9, f15, 0.0, 0.0, 0.0, 0);
                }
            }
            if (FireBlock.canBurn(world, x, y, z + 1)) {
                for (int l1 = 0; l1 < 2; ++l1) {
                    double f4 = (double)x + (double)rand.nextFloat();
                    double f10 = (double)y + (double)rand.nextFloat();
                    double f16 = (double)(z + 1) - (double)(rand.nextFloat() * 0.1f);
                    world.spawnParticle("largesmoke", f4, f10, f16, 0.0, 0.0, 0.0, 0);
                }
            }
            if (!FireBlock.canBurn(world, x, y + 1, z)) break block12;
            for (int i2 = 0; i2 < 2; ++i2) {
                double f5 = (double)x + (double)rand.nextFloat();
                double f11 = (double)(y + 1) - (double)(rand.nextFloat() * 0.1f);
                double f17 = (double)z + (double)rand.nextFloat();
                world.spawnParticle("largesmoke", f5, f11, f17, 0.0, 0.0, 0.0, 0);
            }
        }
    }
}

