/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.RotatableBlock;
import net.minecraft.core.block.entity.ActivatorBlockEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;

public abstract class FullRotatableBlock
extends Block {
    public static final int MASK_DIRECTION = 7;

    public FullRotatableBlock(String translationKey, String namespaceId, int id, Material material) {
        super(translationKey, namespaceId, id, material);
    }

    @Override
    public void onBlockPlacedByMob(World world, int x, int y, int z, @NotNull Side side, Mob mob, double xPlaced, double yPlaced) {
        Direction direction = mob.getPlacementDirection(side).getOpposite();
        world.setBlockMetadataWithNotify(x, y, z, FullRotatableBlock.directionToMeta(direction));
    }

    @Override
    public void onBlockPlacedOnSide(World world, int x, int y, int z, @NotNull Side side, double xPlaced, double yPlaced) {
        Direction direction = side.getOpposite().getDirection();
        world.setBlockMetadataWithNotify(x, y, z, FullRotatableBlock.directionToMeta(direction));
    }

    public static int directionToMeta(Direction direction) {
        return direction.getId() & 7;
    }

    public static Direction metaToDirection(int meta) {
        return Direction.getDirectionById(meta & 7);
    }

    @Override
    public void onBlockPlacedByActivator(World world, int x, int y, int z, ActivatorBlockEntity activator, Direction direction) {
        super.onBlockPlacedByActivator(world, x, y, z, activator, direction);
        world.setBlockMetadataWithNotify(x, y, z, RotatableBlock.setDirection(0, direction));
    }
}

