/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.client.util.helper.Colors;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.VeryRotatableEntityBlock;
import net.minecraft.core.block.entity.BlockEntity;
import net.minecraft.core.block.entity.SensorBlockEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Color;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;

public class MotionSensorBlock
extends VeryRotatableEntityBlock {
    public final boolean isActive;

    public MotionSensorBlock(String key, String namespaceId, int id, boolean isActive) {
        super(key, namespaceId, id, Material.glass);
        this.isActive = isActive;
    }

    @Override
    public void animationTick(World world, int x, int y, int z, Random rand) {
        if (!this.isActive) {
            return;
        }
        this.spawnParticles(world, x, y, z);
    }

    private void spawnParticles(World world, int x, int y, int z) {
        Random random = world.rand;
        int redstoneBrightness = 10;
        Color color = Colors.allRedstoneColors[10];
        if (color == null) {
            return;
        }
        float red = (float)color.getRed() / 255.0f;
        float green = (float)color.getGreen() / 255.0f;
        float blue = (float)color.getBlue() / 255.0f;
        double d = 0.0625;
        for (int i = 0; i < 3; ++i) {
            double px = (double)x + (double)random.nextFloat();
            double py = (double)y + (double)random.nextFloat();
            double pz = (double)z + (double)random.nextFloat();
            if (i == 0 && !world.isBlockOpaqueCube(x, y + 1, z)) {
                py = (double)(y + 1) + d;
            }
            if (i == 1 && !world.isBlockOpaqueCube(x, y - 1, z)) {
                py = (double)(y + 0) - d;
            }
            if (i == 2 && !world.isBlockOpaqueCube(x, y, z + 1)) {
                pz = (double)(z + 1) + d;
            }
            if (i == 3 && !world.isBlockOpaqueCube(x, y, z - 1)) {
                pz = (double)(z + 0) - d;
            }
            if (i == 4 && !world.isBlockOpaqueCube(x + 1, y, z)) {
                px = (double)(x + 1) + d;
            }
            if (i == 5 && !world.isBlockOpaqueCube(x - 1, y, z)) {
                px = (double)(x + 0) - d;
            }
            if (!(px < (double)x || px > (double)(x + 1) || py < 0.0 || py > (double)(y + 1) || pz < (double)z) && !(pz > (double)(z + 1))) continue;
            world.spawnParticle("reddust", px, py, pz, red, green, blue, 10);
        }
    }

    @Override
    public boolean isSignalSource() {
        return true;
    }

    @Override
    public boolean getDirectSignal(World world, int x, int y, int z, Side side) {
        return this.getSignal(world, x, y, z, side);
    }

    @Override
    public boolean getSignal(WorldSource worldSource, int x, int y, int z, Side side) {
        return this.isActive;
    }

    @Override
    protected BlockEntity getNewBlockEntity() {
        return new SensorBlockEntity();
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int meta, BlockEntity blockEntity) {
        switch (dropCause) {
            case WORLD: 
            case EXPLOSION: 
            case PROPER_TOOL: 
            case PICK_BLOCK: 
            case SILK_TOUCH: {
                return new ItemStack[]{new ItemStack(Blocks.MOTION_SENSOR_IDLE)};
            }
        }
        return null;
    }

    public static Direction getFacingDirection(int meta) {
        if (meta == 0) {
            return Direction.DOWN;
        }
        if (meta == 1) {
            return Direction.UP;
        }
        if (meta == 2) {
            return Direction.NORTH;
        }
        if (meta == 3) {
            return Direction.SOUTH;
        }
        if (meta == 4) {
            return Direction.WEST;
        }
        if (meta == 5) {
            return Direction.EAST;
        }
        return Direction.NONE;
    }
}

