/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.FlowerBlock;
import net.minecraft.core.world.World;

public class MushroomBlock
extends FlowerBlock {
    public MushroomBlock(String key, String namespaceId, int id) {
        super(key, namespaceId, id);
        float f = 0.2f;
        this.setBlockBounds(0.5f - f, 0.0, 0.5f - f, 0.5f + f, f * 2.0f, 0.5f + f);
        this.setTicking(true);
    }

    @Override
    public void updateTick(World world, int x, int y, int z, Random rand) {
        int z2;
        int x2;
        int z1;
        int randY;
        int x1;
        if (rand.nextInt(100) == 0 && world.isAirBlock(x1 = z + rand.nextInt(3) - 1, randY = y + rand.nextInt(2) - rand.nextInt(2), z1 = x + rand.nextInt(3) - 1) && this.canBlockStay(world, x1, randY, z1) && world.isAirBlock(x2 = x + rand.nextInt(3) - 1, randY, z2 = z + rand.nextInt(3) - 1) && this.canBlockStay(world, x2, randY, z2)) {
            world.setBlockWithNotify(x2, randY, z2, this.id);
        }
    }

    @Override
    protected boolean mayPlaceOn(int blockId) {
        return Block.solid[blockId];
    }

    @Override
    public boolean canBlockStay(World world, int x, int y, int z) {
        if (y < 0 || y >= world.getHeightBlocks()) {
            return false;
        }
        return world.getFullBlockLightValue(x, y, z) < 13 && this.mayPlaceOn(world.getBlockId(x, y - 1, z));
    }
}

