/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.BaseLeavesBlock;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.BlockEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.world.World;

public class PineLeavesBlock
extends BaseLeavesBlock {
    public PineLeavesBlock(String key, String namespaceId, int id) {
        super(key, namespaceId, id, Material.leaves);
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int meta, BlockEntity blockEntity) {
        if (dropCause == EnumDropCause.PICK_BLOCK || dropCause == EnumDropCause.SILK_TOUCH) {
            return new ItemStack[]{new ItemStack(this)};
        }
        int numDropped = 1;
        if (world.rand.nextInt(20) != 0) {
            return null;
        }
        return new ItemStack[]{new ItemStack(this.getSapling(), numDropped)};
    }

    @Override
    protected Block getSapling() {
        return Blocks.SAPLING_PINE;
    }
}

