/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.client.util.helper.Colors;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.BlockEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.util.helper.Color;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;

public class RedstoneOreBlock
extends Block {
    public static Map<Integer, Integer> variantMap = new HashMap<Integer, Integer>();
    private final boolean illuminated;
    private final Supplier<Block> normalBlock;
    private final Supplier<Block> illuminatedBlock;

    public RedstoneOreBlock(String key, String namespaceId, int id, int parentId, Material material, boolean illuminated, Supplier<Block> normalBlock, Supplier<Block> illuminatedBlock) {
        super(key, namespaceId, id, material);
        if (illuminated) {
            this.setTicking(true);
        }
        this.illuminated = illuminated;
        this.normalBlock = normalBlock;
        this.illuminatedBlock = illuminatedBlock;
        if (parentId > 0) {
            variantMap.put(parentId, id);
        }
    }

    @Override
    public int tickDelay() {
        return 30;
    }

    @Override
    public void onBlockLeftClicked(World world, int x, int y, int z, Player player, Side side, double xHit, double yHit) {
        this.lightRedstone(world, x, y, z);
        super.onBlockLeftClicked(world, x, y, z, player, side, xHit, yHit);
    }

    @Override
    public void onEntityWalking(World world, int x, int y, int z, Entity entity) {
        this.lightRedstone(world, x, y, z);
        super.onEntityWalking(world, x, y, z, entity);
    }

    private void lightRedstone(World world, int x, int y, int z) {
        this.spawnParticles(world, x, y, z);
        if (!this.illuminated) {
            world.setBlockWithNotify(x, y, z, this.illuminatedBlock.get().id);
        }
    }

    @Override
    public void updateTick(World world, int x, int y, int z, Random rand) {
        if (this.illuminated) {
            world.setBlockWithNotify(x, y, z, this.normalBlock.get().id);
        }
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int meta, BlockEntity blockEntity) {
        switch (dropCause) {
            case SILK_TOUCH: 
            case PICK_BLOCK: {
                return new ItemStack[]{new ItemStack(this.normalBlock.get())};
            }
            case EXPLOSION: 
            case PROPER_TOOL: {
                return new ItemStack[]{new ItemStack(Items.DUST_REDSTONE, 4 + world.rand.nextInt(2))};
            }
        }
        return null;
    }

    @Override
    public void animationTick(World world, int x, int y, int z, Random rand) {
        if (this.illuminated) {
            this.spawnParticles(world, x, y, z);
        }
    }

    private void spawnParticles(World world, int x, int y, int z) {
        Random random = world.rand;
        int redstoneBrightness = 10;
        Color color = Colors.allRedstoneColors[10];
        if (color == null) {
            return;
        }
        float red = (float)color.getRed() / 255.0f;
        float green = (float)color.getGreen() / 255.0f;
        float blue = (float)color.getBlue() / 255.0f;
        double d = 0.0625;
        for (int i = 0; i < 3; ++i) {
            double px = (double)x + (double)random.nextFloat();
            double py = (double)y + (double)random.nextFloat();
            double pz = (double)z + (double)random.nextFloat();
            if (i == 0 && !world.isBlockOpaqueCube(x, y + 1, z)) {
                py = (double)(y + 1) + d;
            }
            if (i == 1 && !world.isBlockOpaqueCube(x, y - 1, z)) {
                py = (double)y - d;
            }
            if (i == 2 && !world.isBlockOpaqueCube(x, y, z + 1)) {
                pz = (double)(z + 1) + d;
            }
            if (i == 3 && !world.isBlockOpaqueCube(x, y, z - 1)) {
                pz = (double)z - d;
            }
            if (i == 4 && !world.isBlockOpaqueCube(x + 1, y, z)) {
                px = (double)(x + 1) + d;
            }
            if (i == 5 && !world.isBlockOpaqueCube(x - 1, y, z)) {
                px = (double)x - d;
            }
            if (!(px < (double)x || px > (double)(x + 1) || py < 0.0 || py > (double)(y + 1) || pz < (double)z) && !(pz > (double)(z + 1))) continue;
            world.spawnParticle("reddust", px, py, pz, red, green, blue, 10);
        }
    }
}

