/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.BlockEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.item.ToolShearsItem;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;

public class RopeBlock
extends Block {
    public static final int MASK_ROPE_CONNECT = 128;

    public RopeBlock(String key, String namespaceId, int id) {
        super(key, namespaceId, id, Material.cloth);
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public boolean isClimbable(World world, int x, int y, int z) {
        return true;
    }

    @Override
    public AABB getCollisionBoundingBoxFromPool(WorldSource world, int x, int y, int z) {
        return null;
    }

    @Override
    public void setBlockBoundsBasedOnState(WorldSource world, int x, int y, int z) {
        boolean hasBlockNegX = world.getBlockId(x - 1, y, z) == this.id;
        boolean hasBlockPosX = world.getBlockId(x + 1, y, z) == this.id;
        boolean hasBlockNegY = world.getBlockId(x, y - 1, z) == this.id;
        boolean hasBlockPosY = world.getBlockId(x, y + 1, z) == this.id || world.isBlockOpaqueCube(x, y + 1, z);
        boolean hasBlockNegZ = world.getBlockId(x, y, z - 1) == this.id;
        boolean hasBlockPosZ = world.getBlockId(x, y, z + 1) == this.id;
        float minX = 0.3125f;
        float maxX = 0.6875f;
        float minY = 0.3125f;
        float maxY = 0.6875f;
        float minZ = 0.3125f;
        float maxZ = 0.6875f;
        if (hasBlockNegX) {
            minX = 0.0f;
        }
        if (hasBlockPosX) {
            maxX = 1.0f;
        }
        if (hasBlockNegY) {
            minY = 0.0f;
        }
        if (hasBlockPosY) {
            maxY = 1.0f;
        }
        if (hasBlockNegZ) {
            minZ = 0.0f;
        }
        if (hasBlockPosZ) {
            maxZ = 1.0f;
        }
        this.setBlockBounds(minX, minY, minZ, maxX, maxY, maxZ);
    }

    @Override
    public boolean onBlockRightClicked(World world, int x, int y, int z, Player player, Side side, double xPlaced, double yPlaced) {
        ItemStack heldItem = player.getHeldItem();
        if (heldItem != null && heldItem.getItem() instanceof ToolShearsItem) {
            int meta = world.getBlockMetadata(x, y, z);
            int forceRope = ~meta & 0x80;
            world.setBlockMetadataWithNotify(x, y, z, forceRope | meta & 0xFFFFFF7F);
            heldItem.damageItem(1, player);
            if (heldItem.stackSize <= 0) {
                player.destroyCurrentEquippedItem();
            }
            return true;
        }
        if (heldItem == null) {
            this.pickUpRope(world, x, y, z, player);
            return true;
        }
        return false;
    }

    public void pickUpRope(World world, int x, int y, int z, Player player) {
        ItemStack stack;
        Block block;
        if (world.isClientSide || world.getBlock(x, y, z) != this) {
            return;
        }
        int highestRope = y;
        while (y > 0 && (block = world.getBlock(x, y - 1, z)) == this) {
            --y;
        }
        int lowestRope = y;
        int freeSpace = 0;
        for (int i = 0; i < player.inventory.mainInventory.length; ++i) {
            stack = player.inventory.mainInventory[i];
            if (stack == null) {
                freeSpace += Items.ROPE.getItemStackLimit();
                continue;
            }
            if (stack.getItem() != Items.ROPE) continue;
            freeSpace += Items.ROPE.getItemStackLimit() - stack.stackSize;
        }
        freeSpace = Math.min(freeSpace, 1);
        int ropesCollected = 0;
        for (y = lowestRope; y <= highestRope && ropesCollected < freeSpace; ++ropesCollected, ++y) {
            world.setBlockWithNotify(x, y, z, 0);
        }
        if (player.getGamemode().consumeBlocks()) {
            stack = new ItemStack(Items.ROPE, ropesCollected);
            player.inventory.insertItem(stack, true);
            if (stack.stackSize > 0) {
                player.dropPlayerItem(stack);
            }
        }
        world.playBlockSoundEffect(player, (double)x + 0.5, (double)highestRope + 0.5, (double)z + 0.5, this, EnumBlockSoundEffectType.PLACE);
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int meta, BlockEntity blockEntity) {
        return new ItemStack[]{new ItemStack(Items.ROPE)};
    }
}

