/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.EntityBlock;
import net.minecraft.core.block.RotatableBlock;
import net.minecraft.core.block.entity.ActivatorBlockEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;

public abstract class RotatableEntityBlock
extends EntityBlock {
    public RotatableEntityBlock(String key, String namespaceId, int id, Material material) {
        super(key, namespaceId, id, material);
    }

    @Override
    public void onBlockPlacedByMob(World world, int x, int y, int z, @NotNull Side side, Mob mob, double xPlaced, double yPlaced) {
        world.setBlockMetadataWithNotify(x, y, z, mob.getHorizontalPlacementDirection(side).getOpposite().getId());
    }

    @Override
    public void onBlockPlacedOnSide(World world, int x, int y, int z, @NotNull Side side, double xPlaced, double yPlaced) {
        if (!side.isHorizontal()) {
            side = Side.NORTH;
        }
        world.setBlockMetadataWithNotify(x, y, z, side.getOpposite().getId());
    }

    @Override
    public void onBlockPlacedByActivator(World world, int x, int y, int z, ActivatorBlockEntity activator, Direction direction) {
        super.onBlockPlacedByActivator(world, x, y, z, activator, direction);
        if (direction.getOffsetY() != 0) {
            direction = Direction.NORTH.getOpposite();
        }
        world.setBlockMetadataWithNotify(x, y, z, RotatableBlock.setDirection(0, direction));
    }
}

