/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.LadderBlock;
import net.minecraft.core.block.entity.ActivatorBlockEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.PlacementMode;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.tag.ItemTags;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.util.phys.HitResult;
import net.minecraft.core.util.phys.Vec3;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TrapDoorBlock
extends Block {
    public static final int DIRECTION_SOUTH = 0;
    public static final int DIRECTION_NORTH = 1;
    public static final int DIRECTION_EAST = 2;
    public static final int DIRECTION_WEST = 3;
    public static final int MASK_DIRECTION = 3;
    public static final int MASK_OPEN = 4;
    public static final int MASK_UPPER_HALF = 8;

    public TrapDoorBlock(String key, String namespaceId, int id, Material material) {
        super(key, namespaceId, id, material);
        float f = 0.5f;
        float f1 = 1.0f;
        this.setBlockBounds(0.5f - f, 0.0, 0.5f - f, 0.5f + f, f1, 0.5f + f);
    }

    @Override
    public void onBlockPlacedOnSide(World world, int x, int y, int z, @NotNull Side side, double xPlaced, double yPlaced) {
        boolean isPowered;
        int meta = world.getBlockMetadata(x, y, z);
        boolean isOpened = TrapDoorBlock.isTrapdoorOpen(meta);
        if (isOpened != (isPowered = world.hasNeighborSignal(x, y, z))) {
            world.setBlockMetadataWithNotify(x, y, z, TrapDoorBlock.setTrapdoorOpen(meta, isPowered));
        }
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    public AABB getSelectedBoundingBoxFromPool(WorldSource world, int x, int y, int z) {
        this.setBlockBoundsBasedOnState(world, x, y, z);
        return super.getSelectedBoundingBoxFromPool(world, x, y, z);
    }

    @Override
    public AABB getCollisionBoundingBoxFromPool(WorldSource world, int x, int y, int z) {
        this.setBlockBoundsBasedOnState(world, x, y, z);
        return super.getCollisionBoundingBoxFromPool(world, x, y, z);
    }

    @Override
    public void setBlockBoundsBasedOnState(WorldSource world, int x, int y, int z) {
        int meta = world.getBlockMetadata(x, y, z);
        float thickness = 0.1875f;
        if (TrapDoorBlock.isTrapdoorOpen(meta)) {
            if ((meta & 3) == 0) {
                this.setBlockBounds(0.0, 0.0, 1.0f - thickness, 1.0, 1.0, 1.0);
            }
            if ((meta & 3) == 1) {
                this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 1.0, thickness);
            }
            if ((meta & 3) == 2) {
                this.setBlockBounds(1.0f - thickness, 0.0, 0.0, 1.0, 1.0, 1.0);
            }
            if ((meta & 3) == 3) {
                this.setBlockBounds(0.0, 0.0, 0.0, thickness, 1.0, 1.0);
            }
        } else if (TrapDoorBlock.isUpperHalf(meta)) {
            this.setBlockBounds(0.0, 1.0f - thickness, 0.0, 1.0, 1.0, 1.0);
        } else {
            this.setBlockBounds(0.0, 0.0, 0.0, 1.0, thickness, 1.0);
        }
    }

    @Override
    public void onBlockLeftClicked(World world, int x, int y, int z, Player player, Side side, double xHit, double yHit) {
        if (!Item.hasTag(player.getCurrentEquippedItem(), ItemTags.PREVENT_LEFT_CLICK_INTERACTIONS)) {
            this.onBlockRightClicked(world, x, y, z, player, null, 0.0, 0.0);
        }
    }

    @Override
    public boolean onBlockRightClicked(World world, int x, int y, int z, Player player, Side side, double xPlaced, double yPlaced) {
        if (this.blockMaterial != Material.metal) {
            int l = world.getBlockMetadata(x, y, z);
            world.setBlockMetadataWithNotify(x, y, z, l ^ 4);
            world.playBlockEvent(player, 1003, x, y, z, 0);
            return true;
        }
        return false;
    }

    @Override
    public void onActivatorInteract(World world, int x, int y, int z, ActivatorBlockEntity activator, Direction direction) {
        if (this.blockMaterial != Material.metal) {
            int l = world.getBlockMetadata(x, y, z);
            world.setBlockMetadataWithNotify(x, y, z, l ^ 4);
            world.playBlockEvent(null, 1003, x, y, z, 0);
        }
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        boolean isPowered;
        if (world.isClientSide) {
            return;
        }
        int meta = world.getBlockMetadata(x, y, z);
        boolean isOpened = TrapDoorBlock.isTrapdoorOpen(meta);
        if (isOpened != (isPowered = world.hasNeighborSignal(x, y, z))) {
            world.setBlockMetadataWithNotify(x, y, z, TrapDoorBlock.setTrapdoorOpen(meta, isPowered));
            world.playBlockEvent(null, 1003, x, y, z, 0);
        }
    }

    @Override
    public HitResult collisionRayTrace(World world, int x, int y, int z, Vec3 start, Vec3 end) {
        this.setBlockBoundsBasedOnState(world, x, y, z);
        return super.collisionRayTrace(world, x, y, z, start, end);
    }

    @Override
    public int getPlacedBlockMetadata(@Nullable Player player, ItemStack stack, World world, int x, int y, int z, Side side, double xPlaced, double yPlaced) {
        int meta = this.getMetaForDirection(player == null ? side.getDirection().getOpposite() : player.getHorizontalPlacementDirection(side, PlacementMode.SIDE));
        if (player != null && player.getVerticalPlacementDirection(side, yPlaced) == Direction.UP) {
            meta = TrapDoorBlock.setUpperHalf(meta, true);
        }
        return meta;
    }

    @Override
    public boolean isClimbable(World world, int x, int y, int z) {
        Block block = world.getBlock(x, y - 1, z);
        int meta = world.getBlockMetadata(x, y, z);
        if (TrapDoorBlock.isTrapdoorOpen(meta) && block instanceof LadderBlock) {
            LadderBlock ladder = (LadderBlock)block;
            Side ladderSide = ladder.getSideFromMeta(world.getBlockMetadata(x, y - 1, z));
            Direction trapdoorDirection = this.getDirectionForMeta(meta);
            return ladderSide.getDirection().getOpposite() == trapdoorDirection;
        }
        return false;
    }

    public static boolean isTrapdoorOpen(int metadata) {
        return (metadata & 4) != 0;
    }

    public static int setTrapdoorOpen(int metadata, boolean isOpen) {
        metadata = isOpen ? (metadata |= 4) : (metadata &= 0xFFFFFFFB);
        return metadata;
    }

    public static boolean isUpperHalf(int meta) {
        return (meta & 8) != 0;
    }

    public static int setUpperHalf(int meta, boolean isUpperHalf) {
        meta = isUpperHalf ? (meta |= 8) : (meta &= 0xFFFFFFF7);
        return meta;
    }

    public int getMetaForDirection(Direction dir) {
        switch (dir) {
            case SOUTH: {
                return 0;
            }
            case NORTH: {
                return 1;
            }
            case EAST: {
                return 2;
            }
            case WEST: {
                return 3;
            }
        }
        return 0;
    }

    public Direction getDirectionForMeta(int meta) {
        return Direction.getDirectionById(meta & 3);
    }
}

