/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block.piston;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.EntityBlock;
import net.minecraft.core.block.entity.BlockEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.piston.MovingPistonBlockEntity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import org.jetbrains.annotations.Nullable;

public class MovingPistonBlock
extends EntityBlock {
    public MovingPistonBlock(String key, String namespaceId, int id) {
        super(key, namespaceId, id, Material.piston);
        this.withHardness(-1.0f);
    }

    @Override
    protected BlockEntity getNewBlockEntity() {
        return null;
    }

    @Override
    public void onBlockPlacedByWorld(World world, int x, int y, int z) {
    }

    @Override
    public void onBlockRemoved(World world, int x, int y, int z, int data) {
        BlockEntity blockEntity = world.getBlockEntity(x, y, z);
        if (blockEntity instanceof MovingPistonBlockEntity) {
            ((MovingPistonBlockEntity)blockEntity).finalTick();
        } else {
            super.onBlockRemoved(world, x, y, z, data);
        }
    }

    @Override
    public boolean canPlaceBlockAt(World world, int x, int y, int z) {
        return false;
    }

    @Override
    public boolean canPlaceBlockOnSide(World world, int x, int y, int z, Side side) {
        return false;
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    public boolean onBlockRightClicked(World world, int x, int y, int z, Player player, Side side, double xPlaced, double yPlaced) {
        if (!world.isClientSide && world.getBlockEntity(x, y, z) == null) {
            int id = 0;
            MovingPistonBlockEntity piston = this.getBlockEntity(world, x, y, z);
            if (piston != null) {
                id = piston.getMovedId();
            }
            world.setBlockWithNotify(x, y, z, id);
            return true;
        }
        return false;
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int meta, BlockEntity blockEntity) {
        return null;
    }

    @Override
    public void dropBlockWithCause(World world, EnumDropCause cause, int x, int y, int z, int meta, BlockEntity blockEntity, Player player) {
        if (world.isClientSide) {
            return;
        }
        MovingPistonBlockEntity piston = this.getBlockEntity(world, x, y, z);
        if (piston != null) {
            Block.blocksList[piston.getMovedId()].dropBlockWithCause(world, EnumDropCause.WORLD, x, y, z, meta, null, null);
        }
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        if (world.isClientSide || world.getBlockEntity(x, y, z) != null) {
            // empty if block
        }
    }

    public static BlockEntity createTileEntity(int movedId, int movedData, @Nullable BlockEntity movedEntity, Direction direction, boolean extending, boolean isSourcePiston) {
        assert (!(movedEntity instanceof MovingPistonBlockEntity)) : "Moving piston entity should not be able to be put into another moving piston!";
        return new MovingPistonBlockEntity(movedId, movedData, movedEntity, direction, extending, isSourcePiston);
    }

    @Override
    public AABB getCollisionBoundingBoxFromPool(WorldSource world, int x, int y, int z) {
        MovingPistonBlockEntity tileEntity = this.getBlockEntity(world, x, y, z);
        if (tileEntity == null) {
            return null;
        }
        float progress = tileEntity.getProgress(0.0f);
        if (tileEntity.isExtending()) {
            progress = 1.0f - progress;
        }
        return this.getCollisionShapeFromTileEntity(world, x, y, z, tileEntity.getMovedId(), progress, tileEntity.getDirection());
    }

    @Override
    public void setBlockBoundsBasedOnState(WorldSource world, int x, int y, int z) {
        MovingPistonBlockEntity pistonBlockEntity = this.getBlockEntity(world, x, y, z);
        if (pistonBlockEntity != null) {
            Block block = Block.blocksList[pistonBlockEntity.getMovedId()];
            if (block == null || block == this) {
                return;
            }
            block.setBlockBoundsBasedOnState(world, x, y, z);
            float f = pistonBlockEntity.getProgress(0.0f);
            if (pistonBlockEntity.isExtending()) {
                f = 1.0f - f;
            }
            Direction direction = pistonBlockEntity.getDirection();
            this.minX = block.minX - (double)((float)direction.getOffsetX() * f);
            this.maxX = block.maxX - (double)((float)direction.getOffsetX() * f);
            this.minY = block.minY - (double)((float)direction.getOffsetY() * f);
            this.maxY = block.maxY - (double)((float)direction.getOffsetY() * f);
            this.minZ = block.minZ - (double)((float)direction.getOffsetZ() * f);
            this.maxZ = block.maxZ - (double)((float)direction.getOffsetZ() * f);
        }
    }

    public AABB getCollisionShapeFromTileEntity(WorldSource world, int x, int y, int z, int blockID, float directionStretch, Direction direction) {
        if (blockID == 0 || blockID == this.id) {
            return null;
        }
        AABB aabb = Block.blocksList[blockID].getCollisionBoundingBoxFromPool(world, x, y, z);
        if (aabb == null) {
            return null;
        }
        aabb.minX -= (double)((float)direction.getOffsetX() * directionStretch);
        aabb.maxX -= (double)((float)direction.getOffsetX() * directionStretch);
        aabb.minY -= (double)((float)direction.getOffsetY() * directionStretch);
        aabb.maxY -= (double)((float)direction.getOffsetY() * directionStretch);
        aabb.minZ -= (double)((float)direction.getOffsetZ() * directionStretch);
        aabb.maxZ -= (double)((float)direction.getOffsetZ() * directionStretch);
        return aabb;
    }

    private MovingPistonBlockEntity getBlockEntity(WorldSource world, int x, int y, int z) {
        BlockEntity blockEntity = world.getBlockEntity(x, y, z);
        if (blockEntity instanceof MovingPistonBlockEntity) {
            return (MovingPistonBlockEntity)blockEntity;
        }
        return null;
    }
}

