/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block.piston;

import com.mojang.nbt.CompoundTag;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.BlockEntity;
import net.minecraft.core.block.entity.BlockEntityDispatcher;
import net.minecraft.core.block.piston.MovingPistonBlock;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.Nullable;

public class MovingPistonBlockEntity
extends BlockEntity {
    public static final int TICKS_TO_EXTEND = 2;
    private static final List<Entity> entityBuffer = new ArrayList<Entity>();
    private int movedId;
    private int movedData;
    @Nullable
    private BlockEntity movedEntity;
    private Direction direction;
    private boolean extending;
    private boolean isSourcePiston;
    private float progress;
    private float progressO;

    public MovingPistonBlockEntity() {
    }

    public MovingPistonBlockEntity(int movedId, int movedData, @Nullable BlockEntity movedEntity, Direction direction, boolean extending, boolean isSourcePiston) {
        this.movedId = movedId;
        this.movedData = movedData;
        this.movedEntity = movedEntity;
        this.direction = direction;
        this.extending = extending;
        this.isSourcePiston = isSourcePiston;
        this.progressO = 0.0f;
        this.progress = 0.0f;
    }

    public int getMovedId() {
        return this.movedId;
    }

    public int getMovedData() {
        return this.movedData;
    }

    @Nullable
    public BlockEntity getMovedEntity() {
        return this.movedEntity;
    }

    public boolean isExtending() {
        return this.extending;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public boolean isSourcePiston() {
        return this.isSourcePiston;
    }

    public float getProgress(float partialTick) {
        if (partialTick > 1.0f) {
            partialTick = 1.0f;
        }
        return this.progressO + (this.progress - this.progressO) * partialTick;
    }

    public float getXOff(float partialTick) {
        if (this.extending) {
            return (this.getProgress(partialTick) - 1.0f) * (float)this.direction.getOffsetX();
        }
        return (1.0f - this.getProgress(partialTick)) * (float)this.direction.getOffsetX();
    }

    public float getYOff(float partialTick) {
        if (this.extending) {
            return (this.getProgress(partialTick) - 1.0f) * (float)this.direction.getOffsetY();
        }
        return (1.0f - this.getProgress(partialTick)) * (float)this.direction.getOffsetY();
    }

    public float getZOff(float partialTick) {
        if (this.extending) {
            return (this.getProgress(partialTick) - 1.0f) * (float)this.direction.getOffsetZ();
        }
        return (1.0f - this.getProgress(partialTick)) * (float)this.direction.getOffsetZ();
    }

    private void moveCollidedEntities(float stretch, float force) {
        stretch = !this.extending ? (stretch -= 1.0f) : 1.0f - stretch;
        AABB aabb = ((MovingPistonBlock)Blocks.PISTON_MOVING).getCollisionShapeFromTileEntity(this.worldObj, this.x, this.y, this.z, this.movedId, stretch, this.direction);
        if (aabb == null) {
            return;
        }
        List<Entity> list = this.worldObj.getEntitiesWithinAABBExcludingEntity(null, aabb);
        if (!list.isEmpty()) {
            entityBuffer.addAll(list);
            for (Entity entity : entityBuffer) {
                if (entity == null || entity.noPhysics) continue;
                entity.move(force * (float)this.direction.getOffsetX(), force * (float)this.direction.getOffsetY(), force * (float)this.direction.getOffsetZ());
            }
            entityBuffer.clear();
        }
    }

    public void finalTick() {
        this.progress = 1.0f;
        this.progressO = 1.0f;
        this.worldObj.removeBlockTileEntity(this.x, this.y, this.z);
        this.invalidate();
        if (this.worldObj.getBlockId(this.x, this.y, this.z) == Blocks.PISTON_MOVING.id) {
            this.worldObj.setBlockAndMetadataRaw(this.x, this.y, this.z, this.movedId, this.movedData);
            if (this.movedEntity != null) {
                BlockEntity oldEnt = this.worldObj.getBlockEntity(this.x, this.y, this.z);
                if (oldEnt != null) {
                    oldEnt.invalidate();
                }
                this.movedEntity.validate();
                this.movedEntity.x = this.x;
                this.movedEntity.y = this.y;
                this.movedEntity.z = this.z;
                this.worldObj.replaceBlockTileEntity(this.x, this.y, this.z, this.movedEntity);
            }
            if (this.movedId != 0) {
                Block.blocksList[this.movedId].onBlockPlacedByWorld(this.worldObj, this.x, this.y, this.z);
            }
            this.worldObj.notifyBlockChange(this.x, this.y, this.z, this.movedId);
        }
    }

    @Override
    public void tick() {
        this.progressO = this.progress;
        if (this.progressO >= 1.0f) {
            this.moveCollidedEntities(1.0f, 0.25f);
            this.finalTick();
            return;
        }
        this.progress += 0.5f;
        if (this.progress >= 0.999f) {
            this.progress = 1.0f;
        }
        if (this.extending) {
            this.moveCollidedEntities(this.progress, this.progress - this.progressO + 0.0625f);
        }
    }

    @Override
    public void readFromNBT(CompoundTag tag) {
        super.readFromNBT(tag);
        this.movedId = tag.getInteger("blockId");
        this.movedData = tag.getInteger("blockData");
        if (tag.containsKey("blockEntity")) {
            CompoundTag entityTag = tag.getCompound("blockEntity");
            this.movedEntity = BlockEntityDispatcher.createAndLoadEntity(entityTag);
        }
        this.direction = Direction.getDirectionById(tag.getInteger("facing"));
        this.progressO = this.progress = tag.getFloat("progress");
        this.extending = tag.getBoolean("extending");
    }

    @Override
    public void writeToNBT(CompoundTag tag) {
        super.writeToNBT(tag);
        tag.putInt("blockId", this.movedId);
        tag.putInt("blockData", this.movedData);
        if (this.movedEntity != null) {
            CompoundTag entityTag = new CompoundTag();
            this.movedEntity.writeToNBT(entityTag);
            tag.put("blockEntity", entityTag);
        }
        tag.putInt("facing", this.direction.getId());
        tag.putFloat("progress", this.progressO);
        tag.putBoolean("extending", this.extending);
    }

    @Override
    public boolean canBeCarried(World world, Entity potentialHolder) {
        return false;
    }
}

