/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.entity.monster;

import com.mojang.nbt.CompoundTag;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.PathfinderMob;
import net.minecraft.core.entity.monster.Enemy;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.LightLayer;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.phys.Vec3;
import net.minecraft.core.world.World;
import net.minecraft.core.world.season.Seasons;

public abstract class Monster
extends PathfinderMob
implements Enemy {
    protected int attackStrength = 2;

    public Monster(World world) {
        super(world);
    }

    @Override
    public int getMaxHealth() {
        return 20;
    }

    @Override
    protected void updateAI() {
        if (this.closestFireflyEntity == null) {
            this.closestFireflyEntity = this.getClosestFireflyToEntity((int)this.x, (int)this.y, (int)this.z, 8.0f);
        }
        if (this.closestFireflyEntity != null) {
            double dX = this.x - this.closestFireflyEntity.x;
            double dZ = this.z - this.closestFireflyEntity.z;
            double hypotenuse = Math.sqrt(dX * dX + dZ * dZ);
            double scaleFactor = hypotenuse / 8.0;
            Vec3 distanceXYZ = Vec3.getTempVec3(this.x + (dX *= scaleFactor), this.y, this.z + (dZ *= scaleFactor));
            this.pathToEntity = this.world.getEntityPathToXYZ(this, MathHelper.floor(distanceXYZ.x), MathHelper.floor(this.y), MathHelper.floor(distanceXYZ.z), 16.0f);
        }
        super.updateAI();
    }

    @Override
    public void onLivingUpdate() {
        float f = this.getBrightness(1.0f);
        if (f > 0.5f) {
            this.entityAge += 2;
        }
        super.onLivingUpdate();
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.world.isClientSide && !this.world.getDifficulty().canHostileMobsSpawn()) {
            this.remove();
        }
    }

    @Override
    protected Entity findPlayerToAttack() {
        Player entityplayer = this.world.getClosestPlayerToEntity(this, 16.0);
        if (entityplayer != null && this.canEntityBeSeen(entityplayer) && entityplayer.getGamemode().areMobsHostile()) {
            return entityplayer;
        }
        return null;
    }

    @Override
    public int getMaxSpawnedInChunk() {
        if (this.world.getSeasonManager().getCurrentSeason() == Seasons.OVERWORLD_SPRING) {
            return 2;
        }
        if (this.world.getSeasonManager().getCurrentSeason() == Seasons.OVERWORLD_WINTER) {
            return 8;
        }
        return 4;
    }

    @Override
    public boolean hurt(Entity attacker, int i, DamageType type) {
        if (super.hurt(attacker, i, type)) {
            if (this.passenger == attacker || this.vehicle == attacker) {
                return true;
            }
            if (attacker != this) {
                this.target = attacker;
            }
            return true;
        }
        return false;
    }

    @Override
    protected void attackEntity(Entity entity, float distance) {
        if (this.attackTime <= 0 && distance < 2.0f && entity.bb.maxY > this.bb.minY && entity.bb.minY < this.bb.maxY) {
            this.attackTime = 20;
            entity.hurt(this, this.attackStrength, DamageType.COMBAT);
        }
    }

    @Override
    protected float getBlockPathWeight(int x, int y, int z) {
        return 0.5f - this.world.getLightBrightness(x, y, z);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
    }

    @Override
    public boolean canSpawnHere() {
        int blockZ;
        int blockY;
        int blockX = MathHelper.floor(this.x);
        if (this.world.getSavedLightValue(LightLayer.Block, blockX, blockY = MathHelper.floor(this.bb.minY), blockZ = MathHelper.floor(this.z)) > 0) {
            return false;
        }
        if (this.world.getSavedLightValue(LightLayer.Sky, blockX, blockY, blockZ) > this.random.nextInt(32)) {
            return false;
        }
        int blockLight = this.world.getBlockLightValue(blockX, blockY, blockZ);
        if (this.world.getCurrentWeather() != null && this.world.getCurrentWeather().doMobsSpawnInDaylight) {
            blockLight /= 2;
        }
        return blockLight <= 4 && super.canSpawnHere();
    }
}

