/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item;

import net.minecraft.core.block.Blocks;
import net.minecraft.core.entity.PaintingEntity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;

public class PaintingItem
extends Item {
    public PaintingItem(String name, String namespaceId, int id) {
        super(name, namespaceId, id);
    }

    @Override
    public ItemStack onUseItem(ItemStack itemstack, World world, Player entityplayer) {
        if (!world.isClientSide && !entityplayer.isSneaking()) {
            entityplayer.displayPaintingPickerScreen();
        }
        return itemstack;
    }

    @Override
    public boolean onUseItemOnBlock(ItemStack itemstack, Player entityplayer, World world, int blockX, int blockY, int blockZ, Side side, double xPlaced, double yPlaced) {
        PaintingEntity entity;
        int sideHit = side.getId();
        if (sideHit == 0) {
            return false;
        }
        if (sideHit == 1) {
            return false;
        }
        int direction = 0;
        if (sideHit == 4) {
            direction = 1;
        }
        if (sideHit == 3) {
            direction = 2;
        }
        if (sideHit == 5) {
            direction = 3;
        }
        if ((entity = new PaintingEntity(world, blockX, blockY, blockZ, direction, entityplayer.getSelectedArt().key)).canStay()) {
            if (!world.isClientSide) {
                world.entityJoinedWorld(entity);
            }
            world.playBlockSoundEffect(entityplayer, (float)blockX + 0.5f, (float)blockY + 0.5f, (float)blockZ + 0.5f, Blocks.PLANKS_OAK, EnumBlockSoundEffectType.PLACE);
            itemstack.consumeItem(entityplayer);
            return true;
        }
        return false;
    }
}

