/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.command.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.tree.LiteralCommandNode;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.net.command.CommandSource;
import net.minecraft.core.net.command.arguments.IntegerCoordinatesArgumentType;
import net.minecraft.core.net.command.arguments.WorldFeatureArgumentType;
import net.minecraft.core.net.command.exceptions.CommandExceptions;
import net.minecraft.core.net.command.helpers.IntegerCoordinates;
import net.minecraft.core.world.LevelListener;
import net.minecraft.core.world.World;
import net.minecraft.core.world.generate.feature.WorldFeature;

public class PlaceCommand {
    private static final SimpleCommandExceptionType FAILURE = new SimpleCommandExceptionType(() -> I18n.getInstance().translateKey("command.commands.place.exception_failure"));

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralCommandNode<CommandSource> command = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal("place").requires(CommandSource::hasAdmin)).then(RequiredArgumentBuilder.argument("feature", WorldFeatureArgumentType.worldFeature()).then(RequiredArgumentBuilder.argument("position", IntegerCoordinatesArgumentType.intCoordinates()).executes(c -> {
            int z;
            int y;
            CommandSource source = (CommandSource)c.getSource();
            WorldFeature feature = c.getArgument("feature", WorldFeature.class);
            IntegerCoordinates coordinates = c.getArgument("position", IntegerCoordinates.class);
            World world = source.getWorld();
            if (coordinates == null) {
                throw CommandExceptions.notInWorld().create();
            }
            int x = coordinates.getX(source);
            boolean success = feature.place(world, source.getWorld().rand, x, y = coordinates.getY(source, true), z = coordinates.getZ(source));
            if (success) {
                for (LevelListener listener : world.listeners) {
                    listener.allChanged(true, false);
                }
            } else {
                throw FAILURE.create();
            }
            source.sendTranslatableMessage("command.commands.place.success", feature.getClass().getSimpleName().substring(12), x, y, z);
            return 1;
        }))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal("generate").requires(CommandSource::hasAdmin)).redirect(command));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal("gen").requires(CommandSource::hasAdmin)).redirect(command));
    }
}

