/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.command.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.net.command.CommandSource;
import net.minecraft.core.net.command.arguments.EntitySummonArgumentType;
import net.minecraft.core.net.command.arguments.Vec3ArgumentType;
import net.minecraft.core.net.command.exceptions.CommandExceptions;
import net.minecraft.core.net.command.helpers.DoubleCoordinates;
import net.minecraft.core.net.command.util.CommandHelper;
import net.minecraft.core.util.phys.Vec3;
import net.minecraft.core.world.World;

public class SummonCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal("summon").requires(CommandSource::hasAdmin)).then(((RequiredArgumentBuilder)RequiredArgumentBuilder.argument("entity", EntitySummonArgumentType.entity()).executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            Vec3 coordinates = source.getCoordinates(false);
            if (source.getSender() == null || coordinates == null) {
                throw CommandExceptions.notInWorld().create();
            }
            Entity entity = SummonCommand.summonEntityAt(c, coordinates.x, coordinates.y - (double)source.getSender().heightOffset, coordinates.z, 0.0f, 0.0f);
            source.sendTranslatableMessage("command.commands.summon.success_single_entity", CommandHelper.getEntityName(entity));
            return 1;
        })).then(((RequiredArgumentBuilder)RequiredArgumentBuilder.argument("position", Vec3ArgumentType.vec3d()).executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            DoubleCoordinates coordinates = c.getArgument("position", DoubleCoordinates.class);
            Entity entity = SummonCommand.summonEntityAt(c, coordinates.getX(source), coordinates.getY(source, true), coordinates.getZ(source), 0.0f, 0.0f);
            source.sendTranslatableMessage("command.commands.summon.success_single_entity", CommandHelper.getEntityName(entity));
            return 1;
        })).then(RequiredArgumentBuilder.argument("amount", IntegerArgumentType.integer(1, 255)).executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            DoubleCoordinates coordinates = c.getArgument("position", DoubleCoordinates.class);
            int amount = c.getArgument("amount", Integer.class);
            for (int i = 0; i < amount; ++i) {
                SummonCommand.summonEntityAt(c, coordinates.getX(source), coordinates.getY(source, true), coordinates.getZ(source), 0.0f, 0.0f);
            }
            source.sendTranslatableMessage("command.commands.summon.success_multiple_entities", amount);
            return 1;
        })))));
    }

    private static Entity summonEntityAt(CommandContext<CommandSource> c, double x, double y, double z, float yaw, float pitch) {
        Entity entity;
        Class entityClass = c.getArgument("entity", Class.class);
        try {
            entity = (Entity)entityClass.getConstructor(World.class).newInstance(c.getSource().getWorld());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        entity.spawnInit();
        entity.moveTo(x, y, z, yaw, pitch);
        c.getSource().getWorld().entityJoinedWorld(entity);
        return entity;
    }
}

