/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.packet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import net.minecraft.core.entity.EntityDispatcher;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.net.handler.PacketHandler;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.data.SynchedEntityData;

public class AddMobPacket
extends Packet {
    public int id;
    public short type;
    public int x;
    public int y;
    public int z;
    public byte yaw;
    public byte pitch;
    private SynchedEntityData metaData;
    private List<SynchedEntityData.DataItem<?>> unpackedData;
    public String nickname;
    public byte chatColor;

    public AddMobPacket() {
    }

    public AddMobPacket(Mob entityliving) {
        this.id = entityliving.id;
        this.type = (short)EntityDispatcher.getEntityID(entityliving);
        this.x = MathHelper.floor(entityliving.x * 32.0);
        this.y = MathHelper.floor(entityliving.y * 32.0);
        this.z = MathHelper.floor(entityliving.z * 32.0);
        this.yaw = (byte)(entityliving.yRot * 256.0f / 360.0f);
        this.pitch = (byte)(entityliving.xRot * 256.0f / 360.0f);
        this.metaData = entityliving.getEntityData();
        this.nickname = entityliving.nickname;
        this.chatColor = entityliving.chatColor;
    }

    @Override
    public void read(DataInputStream dis) throws IOException {
        this.id = dis.readInt();
        this.type = dis.readShort();
        this.x = dis.readInt();
        this.y = dis.readInt();
        this.z = dis.readInt();
        this.yaw = dis.readByte();
        this.pitch = dis.readByte();
        this.unpackedData = SynchedEntityData.unpack(dis);
        this.nickname = AddMobPacket.readString(dis, 48);
        this.chatColor = dis.readByte();
    }

    @Override
    public void write(DataOutputStream dos) throws IOException {
        dos.writeInt(this.id);
        dos.writeShort(this.type);
        dos.writeInt(this.x);
        dos.writeInt(this.y);
        dos.writeInt(this.z);
        dos.writeByte(this.yaw);
        dos.writeByte(this.pitch);
        this.metaData.packAll(dos);
        AddMobPacket.writeString(this.nickname, dos);
        dos.writeByte(this.chatColor);
    }

    @Override
    public void handlePacket(PacketHandler packetHandler) {
        packetHandler.handleMobSpawn(this);
    }

    @Override
    public int getEstimatedSize() {
        return 21;
    }

    public List<SynchedEntityData.DataItem<?>> getUnpackedData() {
        return this.unpackedData;
    }
}

