/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.chunk;

import net.minecraft.core.block.entity.BlockEntity;
import net.minecraft.core.enums.LightLayer;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.EmptyChunk;

public class DisplayChunk
extends EmptyChunk {
    public static int displayBlockId = 0;
    public static int displayBlockMeta = 0;
    public static int displayBlockPosX = 0;
    public static int displayBlockPosY = 0;
    public static int displayBlockPosZ = 0;
    public static BlockEntity displayBlockEntity = null;

    public DisplayChunk(World world, int x, int z) {
        super(world, x, z);
    }

    @Override
    public int getBlockID(int x, int y, int z) {
        if (x == displayBlockPosX && y == displayBlockPosY && z == displayBlockPosZ) {
            return displayBlockId;
        }
        return 0;
    }

    @Override
    public int getBlockMetadata(int x, int y, int z) {
        if (x == displayBlockPosX && y == displayBlockPosY && z == displayBlockPosZ) {
            return displayBlockMeta;
        }
        return 0;
    }

    @Override
    public int getBrightness(LightLayer layer, int x, int y, int z) {
        return 15;
    }

    @Override
    public boolean setBlockEntity(int x, int y, int z, BlockEntity blockEntity) {
        if (x == displayBlockPosX && y == displayBlockPosY && z == displayBlockPosZ) {
            displayBlockEntity = blockEntity;
            DisplayChunk.displayBlockEntity.worldObj = this.world;
            DisplayChunk.displayBlockEntity.x = x;
            DisplayChunk.displayBlockEntity.y = y;
            DisplayChunk.displayBlockEntity.z = z;
        }
        return true;
    }

    @Override
    public void removeBlockEntity(int x, int y, int z) {
        if (x == displayBlockPosX && y == displayBlockPosY && z == displayBlockPosZ) {
            displayBlockEntity = null;
        }
    }

    @Override
    public BlockEntity getBlockEntity(int x, int y, int z) {
        if (x == displayBlockPosX && y == displayBlockPosY && z == displayBlockPosZ) {
            return displayBlockEntity;
        }
        return null;
    }

    public static void setDisplayTileEntity(World world, BlockEntity entity) {
        displayBlockEntity = entity;
        if (displayBlockEntity != null) {
            DisplayChunk.displayBlockEntity.worldObj = world;
            DisplayChunk.displayBlockEntity.x = displayBlockPosX;
            DisplayChunk.displayBlockEntity.y = displayBlockPosY;
            DisplayChunk.displayBlockEntity.z = displayBlockPosZ;
        }
    }
}

