/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.generate.chunk.perlin.nether;

import java.util.Random;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.SandBlock;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.generate.chunk.ChunkDecorator;
import net.minecraft.core.world.generate.feature.WorldFeatureFire;
import net.minecraft.core.world.generate.feature.WorldFeatureGlowstoneA;
import net.minecraft.core.world.generate.feature.WorldFeatureGlowstoneB;
import net.minecraft.core.world.generate.feature.WorldFeatureLake;
import net.minecraft.core.world.generate.feature.WorldFeatureNetherLava;
import net.minecraft.core.world.generate.feature.WorldFeatureOre;
import net.minecraft.core.world.generate.feature.WorldFeaturePumice;

public class ChunkDecoratorNether
implements ChunkDecorator {
    private final World world;

    public ChunkDecoratorNether(World world) {
        this.world = world;
    }

    @Override
    public void decorate(Chunk chunk) {
        int zf;
        int yf;
        int xf;
        int i;
        int zf2;
        int yf2;
        int xf2;
        int i2;
        int chunkX = chunk.xPosition;
        int chunkZ = chunk.zPosition;
        int minY = this.world.getWorldType().getMinY();
        int maxY = this.world.getWorldType().getMaxY();
        int rangeY = maxY + 1 - minY;
        Random rand = new Random((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
        SandBlock.fallInstantly = true;
        int x = chunkX * 16;
        int z = chunkZ * 16;
        for (i2 = 0; i2 < 8; ++i2) {
            xf2 = x + rand.nextInt(16) + 8;
            yf2 = minY + rand.nextInt(rangeY - 8) + 4;
            zf2 = z + rand.nextInt(16) + 8;
            new WorldFeatureNetherLava(Blocks.FLUID_LAVA_FLOWING.id).place(this.world, rand, xf2, yf2, zf2);
        }
        for (i2 = 0; i2 < 10; ++i2) {
            xf2 = x + rand.nextInt(16);
            yf2 = minY + rand.nextInt(rangeY - 8) + 4;
            zf2 = z + rand.nextInt(16);
            new WorldFeatureOre(Blocks.ORE_NETHERCOAL_NETHERRACK.id, 12).place(this.world, rand, xf2, yf2, zf2);
        }
        int max = rand.nextInt(rand.nextInt(10) + 1);
        for (i = 0; i < max; ++i) {
            xf = x + rand.nextInt(16) + 8;
            yf = minY + rand.nextInt(rangeY - 8) + 4;
            zf = z + rand.nextInt(16) + 8;
            new WorldFeatureFire().place(this.world, rand, xf, yf, zf);
        }
        max = rand.nextInt(rand.nextInt(10) + 1);
        for (i = 0; i < max; ++i) {
            xf = x + rand.nextInt(16) + 8;
            yf = minY + rand.nextInt(rangeY - 8) + 4;
            zf = z + rand.nextInt(16) + 8;
            new WorldFeatureGlowstoneA().place(this.world, rand, xf, yf, zf);
        }
        for (i = 0; i < 10; ++i) {
            xf = x + rand.nextInt(16) + 8;
            yf = minY + rand.nextInt(rangeY - 8) + 4;
            zf = z + rand.nextInt(16) + 8;
            new WorldFeatureGlowstoneB().place(this.world, rand, xf, yf, zf);
        }
        if (rand.nextInt(8) == 0) {
            xf2 = x + rand.nextInt(16) + 8;
            yf2 = minY + rand.nextInt(rangeY - 16) + 8;
            zf2 = z + rand.nextInt(16) + 8;
            new WorldFeatureLake(Blocks.FLUID_LAVA_STILL.id).place(this.world, rand, xf2, yf2, zf2);
        }
        for (i = 0; i < 80; ++i) {
            xf = x + rand.nextInt(16);
            yf = minY + rand.nextInt(rangeY);
            zf = z + rand.nextInt(16);
            new WorldFeaturePumice(32).place(this.world, rand, xf, yf, zf);
        }
        SandBlock.fallInstantly = false;
    }
}

