/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.generate.feature.tree;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.core.block.BaseLeavesBlock;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.FlowerBlock;
import net.minecraft.core.block.LogBlock;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.ChunkPosition;
import net.minecraft.core.world.generate.feature.MethodParametersAnnotation;
import net.minecraft.core.world.generate.feature.WorldFeature;
import net.minecraft.core.world.generate.feature.tree.WorldFeatureTree;

public class WorldFeatureTreePalm
extends WorldFeature {
    protected World world;
    protected Random random;
    protected Block log;
    protected Block leaves;
    protected boolean big;
    protected boolean update;
    protected boolean checkForWater;
    protected ChunkPosition basePos;
    protected ChunkPosition endPos;
    protected float[] leafAngles;
    protected float[] leafAnglesUpper;
    protected int logHeight;
    protected Set<Integer> intSet = new HashSet<Integer>();
    protected List<Integer> intList = new ArrayList<Integer>();

    @MethodParametersAnnotation(names={"log", "leaves", "big", "update"})
    public WorldFeatureTreePalm(Block log, Block leaves, boolean big, boolean update, boolean checkForWater) {
        this.log = log;
        this.leaves = leaves;
        this.update = update;
        this.big = big;
        this.checkForWater = checkForWater;
    }

    @Override
    public boolean place(World world, Random random, int x, int y, int z) {
        this.world = world;
        this.random = random;
        this.basePos = new ChunkPosition(x, y, z);
        int blockBelow = world.getBlockId(x, y - 1, z);
        if (!this.canGrowOnThisBlock(blockBelow, x, y, z)) {
            return false;
        }
        if (!this.generateTrunkIfPossible()) {
            return false;
        }
        WorldFeatureTree.onTreeGrown(world, x, y, z);
        this.calculateLeafAngles();
        this.generateLeaves();
        return true;
    }

    public boolean generateTrunkIfPossible() {
        int height = this.big ? 11 + this.random.nextInt(7) : 7 + this.random.nextInt(3);
        float angle = this.random.nextFloat() * 0.5f + 0.5f;
        float bend = this.big ? this.random.nextFloat() * 5.0f + 2.0f : this.random.nextFloat() * 3.0f + 2.0f;
        Direction direction = Direction.horizontalDirections[this.random.nextInt(4)];
        return this.generateTrunkIfPossible(height, angle, bend, direction);
    }

    public boolean generateTrunkIfPossible(int height, float angle, float bend, Direction direction) {
        int z;
        int y;
        int x;
        int i;
        int offset;
        this.intList.clear();
        this.intSet.clear();
        int i2 = 0;
        while (i2 < height) {
            float yFactor = (float)i2 / (float)height;
            offset = MathHelper.floor(Math.pow(yFactor, angle + 1.0f) * (double)bend);
            int offsetX = direction.getOffsetX() * offset;
            int offsetY = i2++;
            int offsetZ = direction.getOffsetZ() * offset;
            this.intList.add(WorldFeatureTreePalm.encode(offsetX, offsetY, offsetZ));
        }
        int lastPossibleBlockIndex = this.intList.size() - 1;
        for (i = 0; i < this.intList.size(); ++i) {
            offset = this.intList.get(i);
            x = this.basePos.x + WorldFeatureTreePalm.decodeX(offset);
            if (this.isClear(x, y = this.basePos.y + WorldFeatureTreePalm.decodeY(offset), z = this.basePos.z + WorldFeatureTreePalm.decodeZ(offset))) continue;
            lastPossibleBlockIndex = i - 1;
            break;
        }
        for (i = lastPossibleBlockIndex; i >= 0 && !this.isClearRange(x = this.basePos.x + WorldFeatureTreePalm.decodeX(offset = this.intList.get(i).intValue()), y = this.basePos.y + WorldFeatureTreePalm.decodeY(offset), z = this.basePos.z + WorldFeatureTreePalm.decodeZ(offset), 2, 2, 2); --i) {
            lastPossibleBlockIndex = i - 1;
        }
        int minHeight = Math.min(6, height - 2);
        if (lastPossibleBlockIndex < minHeight) {
            return false;
        }
        int x2 = 0;
        int y2 = 0;
        int z2 = 0;
        this.logHeight = lastPossibleBlockIndex + 1;
        for (int i3 = 0; i3 < this.logHeight; ++i3) {
            int offset2 = this.intList.get(i3);
            x2 = this.basePos.x + WorldFeatureTreePalm.decodeX(offset2);
            y2 = this.basePos.y + WorldFeatureTreePalm.decodeY(offset2);
            z2 = this.basePos.z + WorldFeatureTreePalm.decodeZ(offset2);
            this.generateBlock(x2, y2, z2, this.log);
        }
        this.endPos = new ChunkPosition(x2, y2, z2);
        return true;
    }

    public boolean isClear(int x, int y, int z) {
        int id = this.world.getBlockId(x, y, z);
        if (id == 0) {
            return true;
        }
        Block block = Block.getBlock(id);
        if (block instanceof LogBlock) {
            return true;
        }
        if (block instanceof BaseLeavesBlock) {
            return true;
        }
        return block instanceof FlowerBlock;
    }

    public boolean isClearRange(int x, int y, int z, int w, int h, int d) {
        for (int i = -w; i <= w; ++i) {
            for (int j = -h; j <= h; ++j) {
                for (int k = -d; k <= d; ++k) {
                    int x1 = x + i;
                    int y1 = y + j;
                    int z1 = z + k;
                    if (this.isClear(x1, y1, z1)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void calculateLeafAngles() {
        int i;
        int leafCount = 6;
        float baseAngle = 360.0f / (float)leafCount;
        float offset = this.random.nextFloat() * baseAngle;
        this.leafAngles = new float[leafCount];
        for (i = 0; i < leafCount; ++i) {
            float angle;
            this.leafAngles[i] = angle = offset + baseAngle * (float)i;
        }
        this.leafAnglesUpper = new float[leafCount];
        for (i = 0; i < leafCount; ++i) {
            float newAngle;
            float angle2 = this.leafAngles[(i + 1) % leafCount];
            float angle1 = this.leafAngles[i];
            if (angle2 < angle1) {
                angle2 += 360.0f;
            }
            this.leafAnglesUpper[i] = newAngle = (angle1 + angle2) / 2.0f;
        }
    }

    public void generateLeaves() {
        int z;
        int y;
        int x;
        int xyz;
        int j;
        float angle;
        int i;
        float leafLength = this.logHeight >= 10 ? 5.0f : 4.0f;
        for (i = 0; i < this.leafAngles.length; ++i) {
            angle = this.leafAngles[i];
            this.createHorizontalLine(angle, leafLength);
            for (j = 0; j < this.intList.size(); ++j) {
                xyz = this.intList.get(j);
                x = this.endPos.x + WorldFeatureTreePalm.decodeX(xyz);
                y = this.endPos.y;
                z = this.endPos.z + WorldFeatureTreePalm.decodeZ(xyz);
                if (j == 0) {
                    ++y;
                }
                if (j >= this.intList.size() - 1) {
                    --y;
                }
                if (this.world.getBlockId(x, y, z) != 0) continue;
                this.generateBlock(x, y, z, this.leaves);
            }
        }
        for (i = 0; i < this.leafAnglesUpper.length; ++i) {
            angle = this.leafAnglesUpper[i];
            this.createHorizontalLine(angle, leafLength);
            for (j = 0; j < this.intList.size(); ++j) {
                xyz = this.intList.get(j);
                x = this.endPos.x + WorldFeatureTreePalm.decodeX(xyz);
                y = this.endPos.y;
                z = this.endPos.z + WorldFeatureTreePalm.decodeZ(xyz);
                y = j > 1 && j < this.intList.size() - 1 ? (y += 2) : ++y;
                if (this.world.getBlockId(x, y, z) != 0) continue;
                this.generateBlock(x, y, z, this.leaves);
            }
        }
    }

    public void createHorizontalLine(float angle, float length) {
        this.intSet.clear();
        this.intList.clear();
        int iterations = (int)(length * 2.0f);
        double angrad = Math.toRadians(angle);
        float x1 = (float)(Math.sin(angrad) * (double)length);
        float z1 = (float)(-Math.cos(angrad) * (double)length);
        for (int i = 0; i < iterations; ++i) {
            int z;
            float f = (float)i / (float)iterations;
            int x = Math.round(x1 * f);
            int xyz = WorldFeatureTreePalm.encode(x, 0, z = Math.round(z1 * f));
            if (this.intSet.contains(xyz)) continue;
            this.intSet.add(xyz);
            this.intList.add(xyz);
        }
    }

    private boolean waterNearby(int x, int y, int z) {
        int distance = 1;
        for (int xi = x - distance; xi <= x + distance; ++xi) {
            for (int zi = z - distance; zi <= z + distance; ++zi) {
                Block blockAtRange = this.world.getBlock(xi, y - 1, zi);
                if (blockAtRange == null || !blockAtRange.hasTag(BlockTags.IS_WATER)) continue;
                return true;
            }
        }
        return false;
    }

    public void generateBlock(int x, int y, int z, Block block) {
        if (this.update) {
            this.world.setBlockWithNotify(x, y, z, block.id);
        } else {
            this.world.setBlock(x, y, z, block.id);
        }
    }

    public boolean canGrowOnThisBlock(int id, int x, int y, int z) {
        if (Block.hasTag(id, BlockTags.GROWS_TREES)) {
            return true;
        }
        if (id == Blocks.SAND.id) {
            return !this.checkForWater || this.waterNearby(x, y, z);
        }
        return false;
    }

    public static int encode(int x, int y, int z) {
        int x1 = x + 512;
        int y1 = y + 512;
        int z1 = z + 512;
        if (x1 < 0 || x1 >= 1024) {
            throw new IndexOutOfBoundsException("X: " + x);
        }
        if (y1 < 0 || y1 >= 1024) {
            throw new IndexOutOfBoundsException("Y: " + y);
        }
        if (z1 < 0 || z1 >= 1024) {
            throw new IndexOutOfBoundsException("Z: " + z);
        }
        return x1 << 20 | y1 << 10 | z1;
    }

    public static int decodeX(int xyz) {
        return (xyz >> 20 & 0x3FF) - 512;
    }

    public static int decodeY(int xyz) {
        return (xyz >> 10 & 0x3FF) - 512;
    }

    public static int decodeZ(int xyz) {
        return (xyz >> 0 & 0x3FF) - 512;
    }
}

