/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.net.command.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.net.command.CommandSource;
import net.minecraft.core.net.command.exceptions.CommandExceptions;
import net.minecraft.core.util.helper.UUIDHelper;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.entity.player.ServerPlayer;
import net.minecraft.server.net.command.IServerCommandSource;

public class BanCommand {
    private static final DynamicCommandExceptionType FAILURE = new DynamicCommandExceptionType(arg -> () -> I18n.getInstance().translateKeyAndFormat("command.commands.ban.exception_failure", arg));

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal("ban").requires(CommandSource::hasAdmin)).then(LiteralArgumentBuilder.literal("username").then(RequiredArgumentBuilder.argument("name", StringArgumentType.word()).executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            if (!(source instanceof IServerCommandSource)) {
                throw CommandExceptions.multiplayerWorldOnly().create();
            }
            MinecraftServer server = ((IServerCommandSource)((Object)source)).getServer();
            String nameToBan = c.getArgument("name", String.class);
            ServerPlayer player = server.playerList.getPlayerEntity(nameToBan);
            if (player != null) {
                server.playerList.banPlayer(player.uuid);
                ((CommandSource)c.getSource()).sendTranslatableMessage("command.commands.ban.success", player.username);
                player.playerNetServerHandler.kickPlayer("Banned by admin");
            } else {
                UUIDHelper.runConversionAction(nameToBan, uuid -> {
                    server.playerList.banPlayer(uuid);
                    ((CommandSource)c.getSource()).sendTranslatableMessage("command.commands.ban.username.success", nameToBan);
                }, username -> ((CommandSource)c.getSource()).sendTranslatableMessage("command.commands.ban.username.fail.wrong_name", nameToBan));
            }
            return 1;
        })))).then(LiteralArgumentBuilder.literal("ip").then(RequiredArgumentBuilder.argument("address", StringArgumentType.word()).executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            if (!(source instanceof IServerCommandSource)) {
                throw CommandExceptions.multiplayerWorldOnly().create();
            }
            MinecraftServer server = ((IServerCommandSource)((Object)source)).getServer();
            String ip = c.getArgument("address", String.class);
            server.playerList.banIP(ip);
            ((CommandSource)c.getSource()).sendTranslatableMessage("command.commands.ban.ip.success", ip);
            return 1;
        }))));
    }
}

