/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.net.command.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.List;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.net.command.CommandSource;
import net.minecraft.core.net.command.arguments.EntityArgumentType;
import net.minecraft.core.net.command.exceptions.CommandExceptions;
import net.minecraft.core.net.command.helpers.EntitySelector;
import net.minecraft.core.net.packet.UpdatePlayerProfilePacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.entity.player.ServerPlayer;
import net.minecraft.server.net.command.IServerCommandSource;

public class DeopCommand {
    private static final SimpleCommandExceptionType FAILURE = new SimpleCommandExceptionType(() -> I18n.getInstance().translateKey("command.commands.deop.exception_failure"));

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal("deop").requires(CommandSource::hasAdmin)).then(RequiredArgumentBuilder.argument("target", EntityArgumentType.players()).executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            if (!(source instanceof IServerCommandSource)) {
                throw CommandExceptions.multiplayerWorldOnly().create();
            }
            EntitySelector entitySelector = c.getArgument("target", EntitySelector.class);
            List<? extends Entity> entities = entitySelector.get(source);
            MinecraftServer server = ((IServerCommandSource)((Object)source)).getServer();
            boolean deoppedSomeone = false;
            for (Entity entity : entities) {
                ServerPlayer player = (ServerPlayer)entity;
                if (player.isOperator()) {
                    deoppedSomeone = true;
                    server.playerList.deopPlayer(player.uuid);
                    source.sendTranslatableMessage("command.commands.deop.success", player.username);
                    source.sendTranslatableMessage(player, "command.commands.deop.success_receiver", new Object[0]);
                }
                server.playerList.sendPacketToAllPlayers(new UpdatePlayerProfilePacket(player.username, player.nickname, player.uuid, player.score, player.chatColor, true, player.isOperator()));
            }
            if (!deoppedSomeone) {
                throw FAILURE.create();
            }
            return 1;
        })));
    }
}

