/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.net.command.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.net.command.CommandSource;
import net.minecraft.core.net.command.arguments.EntityArgumentType;
import net.minecraft.core.net.command.exceptions.CommandExceptions;
import net.minecraft.core.net.command.helpers.EntitySelector;
import net.minecraft.server.entity.player.ServerPlayer;
import net.minecraft.server.net.command.IServerCommandSource;

public class KickCommand {
    private static final DynamicCommandExceptionType FAILURE = new DynamicCommandExceptionType(arg -> () -> I18n.getInstance().translateKeyAndFormat("command.commands.kick.exception_failure", arg));

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal("kick").requires(CommandSource::hasAdmin)).then(RequiredArgumentBuilder.argument("player", EntityArgumentType.player()).executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            if (!(source instanceof IServerCommandSource)) {
                throw CommandExceptions.multiplayerWorldOnly().create();
            }
            EntitySelector entitySelector = c.getArgument("player", EntitySelector.class);
            ServerPlayer playerToKick = (ServerPlayer)entitySelector.get(source).get(0);
            if (playerToKick == null) {
                throw FAILURE.create(c.getArgument("player", String.class));
            }
            playerToKick.playerNetServerHandler.kickPlayer("Kicked by admin");
            ((CommandSource)c.getSource()).sendTranslatableMessage("command.commands.kick.success", playerToKick.username);
            return 1;
        })));
    }
}

