/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.entity.particle;

import net.minecraft.client.entity.particle.Particle;
import net.minecraft.client.render.TextureManager;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import org.lwjgl.opengl.GL11;

public class FootstepParticle
extends Particle {
    private int life = 0;
    private final int lifeTime;
    private final TextureManager textureManager;

    public FootstepParticle(TextureManager textureManager, World world, double x, double y, double z) {
        super(world, x, y, z, 0.0, 0.0, 0.0);
        this.textureManager = textureManager;
        this.zd = 0.0;
        this.yd = 0.0;
        this.xd = 0.0;
        this.lifeTime = 200;
    }

    @Override
    public void render(Tessellator t, float partialTick, double xOff, double yOff, double zOff, float xa, float ya, float za, float xa2, float za2) {
        float a;
        float time = ((float)this.life + partialTick) / (float)this.lifeTime;
        if ((a = 2.0f - (time *= time) * 2.0f) > 1.0f) {
            a = 1.0f;
        }
        a *= 0.2f;
        GL11.glDisable(2896);
        float s = 0.125f;
        float x = (float)(this.x - xOff);
        float y = (float)(this.y - yOff);
        float z = (float)(this.z - zOff);
        float br = this.world.getLightBrightness(MathHelper.floor(this.x), MathHelper.floor(this.y), MathHelper.floor(this.z));
        this.textureManager.bindTexture(this.textureManager.loadTexture("/assets/minecraft/textures/misc/footprint.png"));
        GL11.glEnable(3042);
        GL11.glBlendFunc(770, 771);
        t.startDrawingQuads();
        t.setColorRGBA_F(br, br, br, a);
        t.addVertexWithUV(x - s, y, z + s, 0.0, 1.0);
        t.addVertexWithUV(x + s, y, z + s, 1.0, 1.0);
        t.addVertexWithUV(x + s, y, z - s, 1.0, 0.0);
        t.addVertexWithUV(x - s, y, z - s, 0.0, 0.0);
        t.draw();
        GL11.glDisable(3042);
        GL11.glEnable(2896);
    }

    @Override
    public void tick() {
        ++this.life;
        if (this.life == this.lifeTime) {
            this.remove();
        }
    }

    @Override
    public int getParticleTexture() {
        return 3;
    }
}

