/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.entity.particle;

import net.minecraft.client.entity.particle.Particle;
import net.minecraft.client.render.EntityRenderDispatcher;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import org.lwjgl.opengl.GL11;

public class TakeAnimationParticle
extends Particle {
    private final Entity item;
    private final Entity target;
    private int life = 0;
    private final int lifeTime;
    private final float yOffs;

    public TakeAnimationParticle(World world, Entity item, Entity target, float scale) {
        super(world, item.x, item.y, item.z, item.xd, item.yd, item.zd);
        this.item = item;
        this.target = target;
        this.lifeTime = 3;
        this.yOffs = scale;
    }

    @Override
    public void render(Tessellator t, float partialTick, double xOff, double yOff, double zOff, float xa, float ya, float za, float xa2, float za2) {
        float time = ((float)this.life + partialTick) / (float)this.lifeTime;
        time *= time;
        double xo = this.item.x;
        double yo = this.item.y;
        double zo = this.item.z;
        double xt = this.target.xo + (this.target.x - this.target.xo) * (double)partialTick;
        double yt = this.target.yo + (this.target.y - this.target.yo) * (double)partialTick + (double)this.yOffs;
        double zt = this.target.zo + (this.target.z - this.target.zo) * (double)partialTick;
        double xx = xo + (xt - xo) * (double)time;
        double yy = yo + (yt - yo) * (double)time;
        double zz = zo + (zt - zo) * (double)time;
        int xTile = MathHelper.floor(xx);
        int yTile = MathHelper.floor(yy + (double)(this.heightOffset / 2.0f));
        int zTile = MathHelper.floor(zz);
        xx -= xOff;
        yy -= yOff;
        zz -= zOff;
        float br = 1.0f;
        if (LightmapHelper.isLightmapEnabled()) {
            LightmapHelper.setLightmapCoord(this.item.world.getLightmapCoord(xTile, yTile, zTile, 0));
        } else {
            br = this.world.getLightBrightness(xTile, yTile, zTile);
        }
        GL11.glColor4f(br, br, br, 1.0f);
        EntityRenderDispatcher.instance.renderEntityWithPosYaw(t, this.item, (float)xx, (float)yy, (float)zz, this.item.yRot, partialTick);
    }

    @Override
    public void tick() {
        ++this.life;
        if (this.life == this.lifeTime) {
            this.remove();
        }
    }

    @Override
    public int getParticleTexture() {
        return 3;
    }
}

