/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.container;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.container.AbstractContainerScreen;
import net.minecraft.core.block.entity.ActivatorBlockEntity;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.player.inventory.container.Inventory;
import net.minecraft.core.player.inventory.menu.ActivatorMenu;
import net.minecraft.core.sound.SoundCategory;
import org.lwjgl.opengl.GL11;

public class ActivatorScreen
extends AbstractContainerScreen {
    protected final ActivatorBlockEntity activatorBlockEntity;
    protected final List<ButtonElement> slotButtons = new ArrayList<ButtonElement>();

    public ActivatorScreen(Inventory inventory, ActivatorBlockEntity activatorBlock) {
        super(new ActivatorMenu(inventory, activatorBlock));
        this.activatorBlockEntity = activatorBlock;
    }

    @Override
    public void init() {
        super.init();
        int xLeft = (this.width - this.xSize) / 2;
        int yTop = (this.height - this.ySize) / 2;
        int startX = xLeft + 7;
        int startY = yTop + 34;
        this.buttons.clear();
        this.slotButtons.clear();
        for (int i = 0; i < this.activatorBlockEntity.getContainerSize(); ++i) {
            ButtonElement button = new ButtonElement(i, startX + 18 * i, startY, 18, 18, "");
            button.visible = false;
            this.slotButtons.add(button);
        }
    }

    @Override
    public void mouseClicked(int mx, int my, int buttonNum) {
        if (buttonNum == 1 && this.mc.thePlayer.inventory.getHeldItemStack() == null) {
            for (ButtonElement button : this.slotButtons) {
                if (this.activatorBlockEntity.getItem(button.id) != null || !button.mouseClicked(this.mc, mx, my)) continue;
                this.activatorBlockEntity.lockSlot(button.id, !this.activatorBlockEntity.locked(button.id));
                if (!button.playSound) break;
                this.mc.sndManager.playSound("random.click", SoundCategory.GUI_SOUNDS, 1.0f, 1.0f);
                break;
            }
        }
        super.mouseClicked(mx, my, buttonNum);
    }

    @Override
    protected void drawGuiContainerForegroundLayer() {
        this.font.drawString(I18n.getInstance().translateKey("gui.activator.label.activator"), 60, 6, 0x404040);
        this.font.drawString(I18n.getInstance().translateKey("gui.activator.label.inventory"), 8, this.ySize - 96 + 2, 0x404040);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float f) {
        GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        this.mc.textureManager.loadTexture("/assets/minecraft/textures/gui/container/activator.png").bind();
        int xLeft = (this.width - this.xSize) / 2;
        int yTop = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(xLeft, yTop, 0, 0, this.xSize, this.ySize);
        if (!this.activatorBlockEntity.locked(this.activatorBlockEntity.stackSelector)) {
            int startX = xLeft + 7;
            int startY = yTop + 26;
            this.drawTexturedModalRect(startX + 18 * this.activatorBlockEntity.stackSelector, startY, 176, 0, 18, 34);
        }
    }
}

